#include "mbed.h"

//DigitalIn Button1(p26); // Button = 1 when the button is not pushed
//DigitalIn Button2(p25); // Button2 : the PWN pushbutton
DigitalOut LED(p22); // normal LED
//PwmOut LED(p22); // PWN object for LED


// Part 1 Extra Credit Setup
// LEDs used to indicate code activity and reset source
DigitalOut myled1(LED1); //in main loop part 1
DigitalOut myled2(LED2); //in main loop part 2 (where fault occurs)
DigitalOut myled3(LED3); //The pushbutton or power on caused a reset
DigitalOut myled4(LED4); //The watchdog timer caused a reset

class Watchdog
{
public:
// Load timeout value in watchdog timer and enable
    void kick(float s) {
        LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
        uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4
        LPC_WDT->WDTC = s * (float)clk;
        LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset
        kick();
    }
// "kick" or "feed" the dog - reset the watchdog timer
// by writing this required bit pattern
    void kick() {
        LPC_WDT->WDFEED = 0xAA;
        LPC_WDT->WDFEED = 0x55;
    }
};

// Setup the watchdog timer
Watchdog wdt;


int main()
{
    // Part 1 - Extra Credit , Watchdog timer
    int count = 0;
// On reset, indicate a watchdog reset or a pushbutton reset on LED 4 or 3
    if ((LPC_WDT->WDMOD >> 2) & 1)
        myled4 = 1;
    else myled3 = 1;

// setup a 5 second timeout on watchdog timer hardware
// needs to be longer than worst case main loop exection time
    wdt.kick(8.0);

// Main program loop - resets watchdog once each loop iteration
// Would typically have a lot of code in loop with many calls
    while (1) {
        LED = 1; // LED is on 
        wait(.05);
        LED = 0; // LED is off
        wait(.05);
// Simulate a fault lock up with an infinite while loop, but only after 25 loop iterations
        if (count == 5) while (1) {};
// LED 2 will stay on during the fault
        LED = 0;
        count ++;
// End of main loop so "kick" to reset watchdog timer and avoid a reset
        wdt.kick();
    }



//    // Part 2 - PWN
//    float dc = 0.5; // 50% duty cycle
//
//    LED.period(0.01f);      // 4 second period
//    LED.write(dc);
//
//    while (1) {
//        if (!Button1) {
//            dc+=0.1;
//            LED.write(dc);
//        } else if (!Button2) {
//            dc-=0.1;
//            LED.write(dc);
//        }
//        wait(0.1);
//    }
}