#include "mbed.h"

/** 
* Speaker Class
*/

class Speaker {
public:
/** Assign a pin to Speaker.
* @param Pin The pin the Speaker will be assigned to
*/
    Speaker(PinName pin);
    /** Write a value a pin to Speaker.
* @param value 
*/
    void rawWrite(float value);
    /**
    *  @param value Writes a scaled uint8_t from RF transmission to the speaker
    */
    void write(uint8_t value);
    /**
    * Writes 0 to the analogOut to completely turn off the speaker
    */
    void turnOff();
    
private:
    AnalogOut _pin;
    float dc;
};