#include "CircularBuf.h"
#include "stdio.h"

template <typename T>
CircularBuf<T>::CircularBuf(unsigned int size) : _size(size), _head(0), _tail(0) {
    _data = (T*)malloc(sizeof(T) * size);
}

template <typename T>
CircularBuf<T>::~CircularBuf() {
    free(_data);
}

template <typename T>
unsigned int CircularBuf<T>::push(T* data, unsigned int size) {
    unsigned int cnt = 0;
    
    for (int i = 0; i < size; i++) {
        unsigned int next = _head + 1;
        
        if (next >= _size)
            next = 0;
            
        if (next ==  _tail)
            return cnt;
            
        _data[next] = data[cnt];
        _head = next;
        cnt++;
    }
    
    return cnt;
}

template <typename T>
unsigned int CircularBuf<T>::pop(T* data, unsigned int size) {
    unsigned int cnt = 0;
    
    for (int i = 0; i < size; i++) {
        unsigned int next = _tail + 1;
        
        if (next >= _size) {
            next = 0;
        }
        
        if (_tail == _head)
            return cnt;
            
        data[cnt] = _data[next];
        _tail = next;
        cnt++;
    }
    
    return cnt;
}

template <typename T>
unsigned int CircularBuf<T>::size() {
    int s = _head - _tail;
    
    // If buffer overlaps end
    if (s < 0)
        s += _size;
        
    return s;
}

template <typename T>
void CircularBuf<T>::clear() {
    _head = 0;
    _tail = 0;
}