#include "Speaker.h"
#define UINT8_MAX 255

Speaker::Speaker(PinName pin) : _pin(pin), dc(0.67f / 3.3f) {}

void Speaker::rawWrite(float value) {
    _pin = value;
}

void Speaker::write(uint8_t value) {
    float sample = (float)value / UINT8_MAX;
    
    _pin = sample;
}

void Speaker::turnOff() {
    _pin = 0.0f;
}