#include  "Microphone.h"
#define UINT8_MAX 255

Microphone::Microphone (PinName pin):
    _pin(pin), dc(.67 / 3.3)
{}

float Microphone::read()
{
    return _pin.read();
}

inline Microphone::operator float ()
{
    return _pin.read();
}

uint8_t Microphone::getData()
{
    // This can be better but this should work for now
    const static float alpha = 0.99999f;
    float sample = (float)read();
    
    dc = alpha*dc + (1.0f - alpha)*sample;
    
    sample = 0.5f + (sample - dc)* 33.0f;
    return sample * UINT8_MAX;
}