#pragma once
// Simple "queue" type data structure
// Data is pushed onto the queue to add it to the FIFO buffer
// It is then popped off the queue to remove it from the FIFO buffer
// (It really should be enqueue and dequeue, but it's too late now)
//
// The circular buffer uses an array as the base and acts just like the name
// suggests
// You can push data on one side and remove from the other
// As you add and remove data, the location of the data "moves" around the circle
// https://en.wikipedia.org/wiki/Circular_buffer
/**
 * Circular Buffer class.
 */
template <typename T>
class CircularBuf {
public:
    /** 
    *  Assigns a circular buffer of the given size.
    * @param size Size of the buffer.
    */
    CircularBuf(unsigned int size);
    ~CircularBuf();
    /**
    * Pushes data onto the buffer. Returns the amount of data actually written.
    * @param Data The array of data to add to the buffer
    * @param size The amount of data in the array.
     
    * (Adds data to the buffer)
    * Argument:/n
    * Data: The array of data to add to the buffer.
    *            data: The array of data to add
    *          size: The amount of data in the array
    * Return:
    *          Amount of data actually written
    *
    * Example Code:
    *
    * int dataToAdd[2];
    * dataToAdd[0] = 15;
    * dataToAdd[1] = 23;
    * buffer.push(dataToAdd, 2);
    *
    * buffer now contains [15, 23]
    */
    unsigned int push(T* data, unsigned int size);
    
    /**
    * Pops data from the buffer
    * @param data The array of data popped
    * @param size The amount of data to pop
    * Return:
    *          Amount of data actually popped
    *
    * Example Code:
    *
    * int dataToRemove[2];
    * buffer.pop(dataToRemove, 2);
    *
    * dataToRemove now contains the 2 oldest values that were in buffer
    */
    unsigned int pop(T* data, unsigned int size);
    
    // Amount of data in the buffer
    unsigned int size();
    
    // Clears the buffer completely
    void clear();
    
    T* _data;
    // Size of the array
    unsigned int _size;
    // Start pointer
    unsigned int _head;
    // End pointer
    unsigned int _tail;
};