/*
typedef struct {
    double x;
    double y;
    int pen;
} Transition;

typedef struct {
    Transition points[10];
} Letter;

Letter let_a = { .points = { {0.0, 0.0, 0}, {0.25, 0.25, 1}, {1.0, 1.175, 1}, {1.75, .25, 1}, {.625, 1.0, 0}, {1.375, 1.0, 1}, {2.0, 0.0, 0} } };
Letter let_h = { .points = { {0.0, 0.0, 0}, {0.0, 2.0, 1}, {2.0, 2.0, 0}, {2.0, 0.0, 1}, {0.0, 1.0, 0}, {2.0, 1.0, 1}, {2.0, 0.0, 0} } };
Letter let_l = { .points = { {0.0, 0.0, 0}, {0.25, 0.25, 1}, {0.25, 1.75, 1}, {0.25, 0.25, 0}, {1.25, 0.25, 1}, {2.0, 0.0, 0}}};
Letter let_e = { .points = { {0.0, 0.0, 0}, {0.25, 0.25, 1}, {0.25, 1.75, 1}, {1, 1.75, 1}, {0.25, 1, 0}, {1, 1, 1}, {0.25, 0.25, 0}, {1, 0.25, 1}, {2.0, 0.0, 0}}};
Letter let_o = { .points = { {0.0, 0.0, 0}, {0.25, 0.25, 1}, {0.25, 1.75, 1}, {1, 1.75, 1}, {1, 0.25, 1}, {0.25, 0.25, 1}, {2.0, 0.0, 0}}};
*/

#include <math.h>
#define PI 3.1415926535

class Transition {
    public:
        double x_init;
        double x_final;
        double y_init;
        double y_final;
        int draw;
        
        Transition (double x_i, double y_i, double x_f, double y_f, int d) {
            x_init = x_i;
            x_final = x_f;
            y_init = y_i;
            y_final = y_f;
            draw = d;
        }
        
        Transition () {}
        
        double desired_angle() {
            return atan2(y_final - y_init, x_final - x_init) * 180.0 / PI;
        }
        
        double distance() {
            return sqrt(pow(y_final - y_init, 2) + pow(x_final - x_init, 2));
        }
};

Transition h1(0,0,.25,.25,false);
Transition h2(.25,.25,.25,1.75,true);
Transition h3(.25,1.75,.25,1,false);
Transition h4(.25,1,1,1,true);
Transition h5(1,1,1,1.75,false);
Transition h6(1,1.75,1,.25,true);
Transition h7(1,.25,2,0,false);

Transition let_h[7] = { h1, h2, h3, h4, h5, h6, h7 };

Transition e1(0,0,1,1.75,false);
Transition e2(1,1.75,0.25,1.75,true);
Transition e3(0.25,1.75,.25,.25,true);
Transition e4(.25,.25,1,.25,true);
Transition e5(1,.25,.25,1,false);
Transition e6(.25,1,1,1,true);
Transition e7(1,1,2,0,false);

Transition let_e[7] = { e1, e2, e3, e4, e5, e6, e7 };

Transition l1(0,0,0.25,1.75,false);
Transition l2(0.25,1.75,0.25,0.25,true);
Transition l3(0.25,0.25,1.25,0.25,true);
Transition l4(1.25,0.25,2,0,false);

Transition let_l[4] = { l1, l2, l3, l4 };

Transition o1(0,0,.25,.25,false);
Transition o2(.25,.25,.25,1.75,true);
Transition o3(.25,1.75,1.75,1.75,true);
Transition o4(1.75,1.75,1.75,.25,true);
Transition o5(1.75,.25,.25,.25,true);
Transition o6(.25,.25,2,0,false);

Transition let_o[6] = { o1, o2, o3, o4, o5, o6 };