/**********************************
 * Author: 
 * Institution: Georgia Tech
 *
 * Title: MAIN
 * Class: ECE2035
 * Assignment: Project 2 Summer 2017
 **********************************/

//includes
#include <string.h>
#include <stdio.h>
#include <math.h>
#include <cstdarg>
#include "mbed.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "MMA8452.h"

#include "uLCD_4DGL.h"

//defines
#define YELLOW              0xFFFF00
#define BUFFSIZE            100
#define PI                  3.141592653589793238462643f
#define TEST_WAVFILE        "/sd/wavfiles/BUZZER.wav"
#define SEQ_LEN             20

//function prototypes
int invert(int value);
void print(const char *format, ...);
void lowerCase(char *src);
void playSound(void);
void pb1_hit_callback(void);
void pb2_hit_callback(void);
void pb3_hit_callback(void);
void pb4_hit_callback(void);
void createSequence(int *Sequence, int length);
void drawFore(int position, int color);
void drawBack(int position, int color);
void drawNum (int i);

//initialize hardware
SDFileSystem sd(p5, p6, p7, p8, "sd"); // mosi, miso, sck, cs
uLCD_4DGL uLCD(p9, p10, p11); // uLCD-144-G2 screen, (serial tx, serial rx, reset pin)
AnalogOut DACout(p18);
wave_player waver(&DACout);

DigitalIn pb1(p21);
DigitalIn pb2(p22);
DigitalIn pb3(p23);
DigitalIn pb4(p24);

AnalogIn   randSeed(p20);

Serial pc(USBTX,USBRX);     // used by Accelerometer
MMA8452 accel(p28, p27, 100000); // Accelerometer

// array for Simon sequence
int Sequence[SEQ_LEN];

//main
int main()
{
    // Use internal pullups for pushbuttons
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    pb4.mode(PullUp);

    //check for wav file
    uLCD.cls();
    uLCD.printf("Locating WAV files...");
    FILE *test_file;
    //while(1) {
    test_file=fopen(TEST_WAVFILE,"r");
    if(test_file != NULL) 
        uLCD.printf("Wav file sucessfully loaded");
    else
        uLCD.printf("Wav file not found");       
     wait(1);
    //}
    //fclose(test_file);

    uLCD.cls(); 

    // set background colors / clear screen
    uLCD.background_color(WHITE);
    uLCD.cls();
    uLCD.background_color(WHITE);
    uLCD.textbackground_color(WHITE);

    //loop
    int val1, val2, val3, val4;
    double x,y,z;

    while(1) {
        //have fun...
        // pushbuttons pull low when pressed, so invert them
        val1 = invert(pb1.read());
        val2 = invert(pb2.read());
        val3 = invert(pb3.read());
        val4 = invert(pb4.read());
        
        accel.readXYZGravity(&x,&y,&z);
        //pc.printf("read gravity: x=%lf, y=%lf, z=%lf\n", x, y, z);        
        
        wait(1);
        
        if(val1|| x>=0.3) { //left = 1
            pb1_hit_callback();
        }
        if(val2 || x<=-0.3){ //right = 2
            pb2_hit_callback();
        }
        if(val3|| y<=-0.3){ //up = 3
            pb3_hit_callback();
        }
        if(val4 || y>=0.3){ // down = 4
            pb4_hit_callback();
        }
        
        // draw some colors
        drawFore(0, RED); 
        wait(0.2);
        drawBack(0, WHITE); 
        drawFore(1, GREEN); 
        wait(0.2);   
        drawBack(1, WHITE);
        drawFore(2, YELLOW);
        wait(0.2);
        drawBack(2, WHITE);
        drawFore(3, BLUE);
        wait(0.2);
        drawBack(3, WHITE); 

    }
    //end loop
}


//create a sequence and store in Sequence[]
void createSequence(int *Sequence, int length)
{
    srand((int ) (randSeed * 50000)); // seed the pseudo-random number generator with electrical noise from a pin
    for(int i=0; i<length; i++) {
        Sequence[i] = rand() % 4;
    }
}

//fcn to play a wav
void playSound(char * wav)
{
    //open wav file
    FILE *wave_file;
    wave_file=fopen(wav,"r");

    //play wav file
    waver.play(wave_file);

    //close wav file
    fclose(wave_file);
}

//fcn to print to console
void print(const char *format, ...)
{
    //temp variables
    char buffer[BUFFSIZE];
    char temp[BUFFSIZE-6];

    //construct message part 1
    sprintf(buffer, "print-");

    //construct message part 2
    va_list arguments;
    va_start(arguments, format);
    vsnprintf(temp, BUFFSIZE-7, format, arguments);
    va_end(arguments);

    //concatenate parts
    strcat(buffer, temp);

    //send message
    pc.printf(buffer);
}

//fcn to convert string to lowercase
void lowerCase(char *src)
{
    int i=0;;
    while(src[i] != '\0') {
        if((src[i] > 64) && (src[i] < 91)) {
            src[i]+=32;
        }
        i++;
    }
    return;
}

//function to perform bitwise inversion
int invert(int value)
{
    if (value == 0) {
        return 1;
    } else {
        return 0;
    }
}

//functions to call when a pushbutton is pressed
void pb1_hit_callback (void)
{
    drawNum(1);
}
void pb2_hit_callback (void)
{
    drawNum(2);
}
void pb3_hit_callback (void)
{
    drawNum(3);
}
void pb4_hit_callback (void)
{
    drawNum(4);
}

//color the background of one of the four corners
void drawBack(int position, int color)
{
    int x11, x12, x21, x22, y11, y12, y21, y22;
    
    switch(position) {
        case 3:
            x11 = 64;
            x12 = 127;
            x21 = 85;
            x22 = 127;
            y11 = 85;
            y12 = 127;
            y21 = 64;
            y22 = 84;     
            break;
        case 2:
            x11 = 0;
            x12 = 63;
            x21 = 0;
            x22 = 42;
            y11 = 85;
            y12 = 127;
            y21 = 64;
            y22 = 84;
            break;
        case 1:
            x11 = 0;
            x12 = 63;
            x21 = 0;
            x22 = 42;
            y11 = 0;
            y12 = 42;
            y21 = 43;
            y22 = 63;
            break;
        default:
            x11 = 64;
            x12 = 127;
            x21 = 85;
            x22 = 127;
            y11 = 0;
            y12 = 42;
            y21 = 43;
            y22 = 63;     
    }
    
    
    uLCD.filled_rectangle(x11, y11, x12, y12, color);
    uLCD.filled_rectangle(x21, y21, x22, y22, color);
}

//color the foreground of one of the four corners
void drawFore(int position, int color)
{
    int x11, x12, x21, x22, y11, y12, y21, y22;
    
    switch(position) {
        case 3:
            x11 = 68;
            x12 = 123;
            x21 = 89;
            x22 = 123;
            y11 = 89;
            y12 = 123;
            y21 = 68;
            y22 = 89;     
            break;
        case 2:
            x11 = 4;
            x12 = 59;
            x21 = 4;
            x22 = 38;
            y11 = 89;
            y12 = 123;
            y21 = 68;
            y22 = 89;
            break;
        case 1:
            x11 = 4;
            x12 = 59;
            x21 = 4;
            x22 = 38;
            y11 = 4;
            y12 = 38;
            y21 = 39;
            y22 = 59;
            break;
        default:
            x11 = 68;
            x12 = 123;
            x21 = 89;
            x22 = 123;
            y11 = 4;
            y12 = 38;
            y21 = 39;
            y22 = 59;     
    }
    
    
    uLCD.filled_rectangle(x11, y11, x12, y12, color);
    uLCD.filled_rectangle(x21, y21, x22, y22, color);
}

//print a number in the middle of the screen
void drawNum(int i) {    
    uLCD.text_width(3);
    uLCD.text_height(3);
    uLCD.color(BLACK);
    uLCD.locate(2,2);
    uLCD.printf("%2D",i);
}