#include "mbed.h"
#include "Servo.h"
// gloabl varevlbe used only inseide the class
int value_current;
int value_target;
float value_target_raw;
Ticker tick;
SLCD slcd;
int n;
char buffer[50];
unsigned int counter;

Servo::Servo(PinName analog_input,PinName Positive, PinName Negative,PinName Speed):
  _feedback(analog_input), _motor(Positive,Negative,Speed) 
{

}
/*
   Degree should be a value from 0 to 180.
   Degree is really from 0 to 100(percent).
*/
void Servo::set(int degree) 
{
  /*
     Sets value_target to the degree value that user wants servo to go to.
  */
  value_target = degree;
  /*
     Counter to store number of tries for motor to be in position.
  */
  counter = 0;
  /*
     Add the servo's move function to the ticker, runs every 1ms.
  */
  tick.attach(this, &Servo::move, 0.01); // set the ticker to call move every 0.001 sec
}

void Servo::move() 
{
  /*
     value_target is destination
     value_current is read from analog
     slcd for the LCD display
  */

  /* Read the potentiometer value. */
  value_current = _feedback*100;
  /*
     When target value is higher relative to
     the value read from the potentiometer
     rotate to the left (Couter-Clockwise).
  */
  if(value_target > value_current)
  {
    _motor.Direction(LEFT);
    counter ++;
  }
  /*
     When target value is lower relative to
     the value read from the potentiometer
     rotate to the right.  (Clockwise).
  */
  else if(value_target < value_current)
  {
    _motor.Direction(RIGHT);
    counter ++;
  }
  /*
     When the motor has been set 2000 times
     change the target value to the current
     value of the analog reading, set the
     counter to 0. 

     Used to prevent rocking between values
     when the MBED cannot get the value from
     the potentiometer.
  */
  else if(counter > 2000)
  {
    value_target = value_current;
    counter = 0;
  }
  /*
     If no if statements are true, stop
     the motor and detatch the tick process.
  */
  else
  {
    tick.detach();
    _motor.Stop();
  }
  /*
     Sprintf to copy the current value into,
     the buffer( n stores status of sprintf()).
  */
  n = sprintf (buffer, "%d", value_current);
  slcd.clear();                /* Clear the SLCD */
  slcd.Home();              /* Set the decimal point on SLCD */
  slcd.printf(buffer);   /* Write the buffer to the SLCD */
}
/*
   Check function to write to SLCD,
   not used.
*/
void Servo::check()
{
  value_current = _feedback*100;
  n = sprintf (buffer, "%d", value_current);
  slcd.clear();
  slcd.Home();
  slcd.printf(buffer);
}
/*
   Returns current position of the analog dial.
   0 to 100.
*/
unsigned int Servo::get()
{
  value_current = _feedback*100;
  return value_current;
}
