#include "mbed_beat_factory.h"
/************************************* Lab3 Mbed beat factory ***************************/
/*                                                                                      */
/*  File: main.cpp                                                                      */
/*  Author: Ziad Eldebri                                                                */
/*  Date Created: 8/6/2016                                                              */
/*  Description: Receives song data from a python GUI and subsequently plays it. It     */
/*               additionally provides the GUI with live song bar updates               */
/*                                                                                      */
/****************************************************************************************/
/**********************
*    Setup Portion    *
**********************/

Serial pc(USBTX, USBRX);
PwmOut Speaker(PTE31);
commStruct comm;
songStruct song;
BusOut test(LED_RED,LED_GREEN);

int freq[25] = {220,233,246,261,277,293,311,329,349,369,392,415,440,466,493,523,554,587,622,659,698,740,784,831,0} ;
//int  freq[25] =  {220,233,261,277,293,220,233,261,277,293,220,233,261,277,293,220,233,261,277,293,220,233,261,277,293};

/************************************* serial_wait_packet     ***************************/
/*                                                                                      */
/*  File: main.cpp                                                                      */
/*  Author: Ziad Eldebri                                                                */
/*  Date Created: 8/6/2016                                                              */
/*  Description: Receives song data from a python GUI and subsequently plays it. It     */
/*               additionally provides the GUI with live song bar updates               */
/*                                                                                      */
/****************************************************************************************/

char serial_wait_packet()
{
    while( !pc.readable()) {};
    return pc.getc();
}


/************************************* get_serial_data        ***************************/
/*                                                                                      */
/*  File: main.cpp                                                                      */
/*  Author: Ziad Eldebri                                                                */
/*  Date Created: 8/6/2016                                                              */
/*  Description: Receives song data from a python GUI and subsequently plays it. It     */
/*               additionally provides the GUI with live song bar updates               */
/*                                                                                      */
/****************************************************************************************/


int get_serial_data()
{

    int byt_count= 0;
    int data_count = 0;

    /* Clear the the data array in the comm struct */
    for( int i = 0; i < 3; i++ ) {
        for( int j = 0; j <3; j++ ) {
            comm.data[ i ][ j ] = 0;
        }
    }




    if(serial_wait_packet() == '$') {
        comm.packetType = pc.getc();

        for(;;) {

            char data = pc.getc();

            if(data == '$' ) {
                return 0;
            } else if(data == '\n') {
                comm.data[data_count][byt_count]= '\n';
                return byt_count ;
            } else {
                comm.data[data_count][byt_count]= data;
                byt_count++;
            }

        }
    }

    return 0;
}

/************************************* extract_from_packet    ***************************/
/*                                                                                      */
/*  File: main.cpp                                                                      */
/*  Author: Ziad Eldebri                                                                */
/*  Date Created: 8/6/2016                                                              */
/*  Description: Receives song data from a python GUI and subsequently plays it. It     */
/*               additionally provides the GUI with live song bar updates               */
/*                                                                                      */
/****************************************************************************************/

void extract_from_packet()
{
    /* Switch to specified packet */
    switch( comm.packetType ) {

            /* New Song Packet */
        case 'N':
            initializeSong();
            break;

            /* Tempo Packet */
        case 'T':
            song.tempo = atoi( comm.data[0] );
            break;

            /* Song length packet */
        case 'L':
            song.notes = atoi( comm.data[0] );
            break;

            /* Song data packet */
        case 'S':
            song.note[ song.currentNote ] = atoi(comm.data[ 0 ]);
            song.currentNote++;
            break;

            /* Play song packet */
        case 'P':
            playSong();
            break;

    }

}

void initializeSong( void )
{
    for( int i = 0; i < 128; i++ ) {
        song.note[i] = 0;
    }
    song.tempo = 120;
    song.notes = 0;
    song.currentNote = 0;
}


void playSong( void )
{


    for( int i = 0; i < song.notes; i++ ) {
        /* Send the current bar we're on to the gui */
        pc.printf("%d\n",i);

        /* Set the frequency of the PWM for the specified note */
        if(song.note[i] == 24) {
            Speaker.period(0);
            Speaker = 0;
        } else {
            Speaker.period( ((float)1/freq[song.note[i]]) );

            Speaker = 0.5;

            /* Wait a specific amount of time based on the tempo */
            wait_ms(((float)((float)60/(float)song.tempo)*(float)1000.0));
            test = ~ test;
        }
    }

    Speaker.period(0);
    Speaker = 0;
    /* Turn off speaker */

    /* Print an end of packet byte 0xFF */
    pc.printf("255\n");

}














int main()
{
    test =3;
    while (true) {

        if( get_serial_data()> 0) {

            extract_from_packet();
            test = 0;
        }


    }

}
