#include "mbed.h"

//This creates Pulse Width Modulated outputs, r and g, and connects them to the red and green LED.
PwmOut r(LED_RED);
PwmOut g(LED_GREEN);

int main()
{
    //The period of the PWM is set to 1 millisecond.
    r.period(0.001f);
    g.period(0.001f);
    while (true) {
        for (float i = 0.0f; i < 1.0f ; i += 0.001f) {
            float j = 2 * i;                            //Sweep the j value between 0 and 2, with .002 steps
            
            if(j<1)
                r=j;
            else
                r=j-1;                                  //Sweep the red LED 2 times during the loop, igorning the integer portion of the float number.
            g = i;                                      //Sweep the green LED 1 time during the loop.
            wait (0.0025f);                             //Wait 2.5 milliseconds per iteration, 2.5 seconds per full loop.
        }
    }
}
