#include "mbed.h"
  
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED3);

DigitalOut myled(LED1);
#include "emic2.h"

emic2 myVoice2Text(p28, p27); //serial RX,TX pins to emic

Serial pc(USBTX, USBRX, 9600); //tx,rx,baud

Serial rs485port1(p9, p10, 9600); //tx,rx,baud
DigitalOut rs485port1mode (p11); //Transmit = 1, Receive = 0

Serial rs485port2(p13, p14, 9600); //tx,rx,baud
DigitalOut rs485port2mode (p12); //Transmit = 1, Receive = 0

int dataRxCnt        = 0;
int dataRxBuffer[4]  = {0};
int cur_address        = 0;
    
char fault[4];
    
void rx485Message() {
    // Note: you need to actually read from the serial to clear the RX interrupt
    int value = rs485port1.getc();
    
    if (value){
        dataRxBuffer[dataRxCnt++]=value;
        
        if(dataRxCnt==4) {
            cur_address = 10*(dataRxBuffer[0] -0x30) + (dataRxBuffer[1] -0x30);
            pc.printf("Received >> %02d \n\r", cur_address);
            memset(dataRxBuffer,0,sizeof(dataRxBuffer));
            dataRxCnt=0;
        }
    }
    myled4 = !myled4;
}


void tx485Message(int address) {
    
    int sum =0;
    
    char dataTxBuffer[12];
    sum += dataTxBuffer[0] = 0x40;
    sum += dataTxBuffer[1]  = 0x01;
    sum += dataTxBuffer[2]  = address; // floor number
    sum += dataTxBuffer[3]  = 0x0;
    sum += dataTxBuffer[4]  = 0x0;
    sum += dataTxBuffer[5]  = 0x0;
    sum += dataTxBuffer[6]  = (0x30 + address / 10); 
    sum += dataTxBuffer[7]  = (0x30 + address % 10); 
    ; //
    sum += dataTxBuffer[8]  = 0x0;
    sum += dataTxBuffer[9]  = 0x0;
    sum += dataTxBuffer[10] = 0x0;
    sum += dataTxBuffer[11] = (char)(~sum +1);
    
    for(int i= 0;i<12;i++){
        rs485port2.putc(dataTxBuffer[i]);
    }
    
}
void say (char *format, ...)
{
    char buffer[128];
    va_list args;
    va_start(args, format);
    vsprintf(buffer,format,args);
    
    myVoice2Text.speakf("S");//Speak command starts with "S"
    myVoice2Text.speakf(buffer);  
    myVoice2Text.speakf("\r"); 
    myVoice2Text.ready(); 
    
    
    va_end(args);
}


int main() {
    
    pc.printf("\n\r");
    pc.printf("------------------------\n\r");
    pc.printf("Serial Test\n\r");
    pc.printf("version = %s %s\n\r", __DATE__, __TIME__ );
    pc.printf("------------------------\n\r");
    rs485port1mode = 0; // Receive
    rs485port2mode = 1; // Transmit
    
    
    myVoice2Text.voice(2);   
    say("hello");
    
    rs485port1.attach(&rx485Message);     
    
    while(1) {
        
        myled1 != myled1;
        wait(0.2);
        
        myled2 = 0;
        myled3 = 0;
        
        #if 0
        if(rs485port1.readable() ) {
            memset(data,0,sizeof(data));
            rs485port1.scanf("%2s", data);
            for (int i = 0 ; i < sizeof(data);i++){
                pc.printf("%02x ", data[i]);
            }
            pc.printf("\n\r");
            
            myled2 = 1;
        }
        else {
            pc.printf("No serial data on port 1.\r\n");
            myled3 = 1;
        }
        #endif
        
        if (cur_address)
        {
            tx485Message(cur_address);
            say("%d is open", cur_address);
        }
                
       wait_ms(1000);
    }
}
