/*
1st Byte:  Header byte:  always 0x40.

2nd Byte:  Is a bit field:    free_a7            :1,    bit 7
            Reserved (fire service)    :1,    bit 6
            Reserved         :1,    bit 5
            Reserved        :1,    bit 4
            Reserved        :1,    bit 3
            play strobe         :1,    bit 2
            arrival_dn_arrow     :1,    bit 1
            arrival_up_arrow     :1,    bit0

3rd Byte:  Scan_slot. zero is reserved, 1 through 254, (119 may be max value in some cases)

4th Byte: Message_number.  zero is no message, 1 through 126, (63 may be max value in some cases)

5th Byte:  Is a bit field:    Rear arrival dn arr    :1,    bit 7
            Rear arrival up arr    :1,    bit 6
            Message level hi bit    :1,    bit 5
            Message level low bit    :1,    bit 4
            Passing chime         :1,    bit 3
            Reserved        :1,    bit 2
            traveling dn arrow    :1,    bit 1
            traveling up arrow    :1,    bit 0

6th Byte:  ASCII floor char, msb.

7th Btye:  ASCII floor char, mid.

8thByte:  ASCII floor char, lsb.
            Note:  floor ASCII range is 0x30 through 0x5a (‘0’ – ‘Z’). 
                0x3a  through 0x40 are special characters with 
                0x3b being the space or blank character(semicolon)
                0x3d is normally displayed as a minus character.
9th Byte:  ASCII Mess. char, msb.

10th Byte:  ASCII Mess. Char, mid.

11th Byte:  ASCII Mess. char, lsb.
            Note:  message ASCII range is 0x30 through 0x5b (‘0’ – ‘[’). 
                0x3a  through 0x40 are special characters with 
                0x3b being the space or blank character(semicolon)
                0x5d is sent when there is no message (instead of spaces).
                So bytes 9, 10, and 11 will each be ‘[‘  when no message. 
12th Byte: checksum, two’s complement of bytes 1 through 11.

Example:
 0x40,    header
 0x01,    up arrow for lantern
 0x01,     floor number 1,
 0x03,    message number 3 activated 
 0x11,    message level 1, direction arrow is up
 0x4c,    ascii floor character ‘L’
 0x42,    ascii floor character ‘B,
 0x59,    ascii floor character ‘Y’
 0x3b,    ascii message character ‘;’ for space or blank
 0x4e,    ascii message character ‘N’
 0x44,    ascii message character ‘D’
 0xf6,    checksum (two’s complement). 
 */
 
class MicroComMessage
{
    public:
        uint8_t message[12];
        
        uint8_t * getMessage(){ return message;};
        
        
        
        void SetFloor(char* floor) {};
        
        void SetMessage( char* msg){};
        
        
        
};

/*
Floor and Arrow Information (0x501)
The floor and arrow information contains the current car position and hall arrows.
Packet Data
Byte 1
Front arrows
Bit 0 – Front arrival arrow up
Bit 1 – Front arrival arrow down
Bit 2 – Play Strobe
Bit 3-5 – Reserved
Bit 6 – Fire Warning Lamp
Byte 2
Floor Number.  A floor number of 0 is not a valid.
Byte 3
Priority message number
Byte 4
Travel and rear arrows
Bit 0 – Travel arrow up
Bit 1 – Travel arrow down
Bit 2 – unused
Bit 3 – Passing Chime
Bit 4 – Message Level Low Bit
Bit 5 – Message Level High Bit
Bit 6 – Rear arrival arrow up
Bit 7 – Rear arrival arrow down
Byte 5-8
Reserved
*/

void GetMessage501(char * floor, char * msg, char lantern )
{
}
/*
Floor and Message characters (0x502)
The floor and message characters packet contains the marking used to represent the floor or priority message on displays.
Packet Data
    Byte 1    Floor marking character (leftmost)
    Byte 2    Floor marking character
    Byte 3    Floor marking character (rightmost)
    Byte 4    Message marking character (leftmost)
    Byte 5    Message marking character
    Byte 6    Message marking character (rightmost)
    Byte 7    Lantern Position (ThyssenKrupp)
    Byte 8    Unused

*/
void GetMessage502(char * floor, char * msg, char lantern )
{
}