/**************************************************************************
 * @file     FactorResetMenu.cpp
 * @brief    Base class for implementing the Factor Reset Menu display
 * @version: V1.0
 * @date:    9/17/2019

 *
 * @note
 * Copyright (C) 2019 E3 Design. All rights reserved.
 *
 * @par
 * E3 Designers LLC is supplying this software for use with Cortex-M3 LPC1768
 * processor based microcontroller for the ESCM 2000 Monitor and Display.  
 *  *
 * @par
 * THIS SOFTWARE IS PROVIDED "AS IS".  NO WARRANTIES, WHETHER EXPRESS, IMPLIED
 * OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE.
 * ARM SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 ******************************************************************************/
#include "mbed.h"
#include "FactoryResetMenu.h"
#include "TimeUtilities.h"
#include "ESCMControlApp.h"

#define DEFAULT_DISPLAY 0

/******************************************************************************/
FactoryResetMenu::FactoryResetMenu(char* id): Menu(id)
{
    active_selection=0;
}



/******************************************************************************/
void FactoryResetMenu::init()
{
    update_needed    = 1;
    active_selection=0;
}

/******************************************************************************/
void FactoryResetMenu::display(LCD * lcd) 
{
    static int counter = 5;
    
    if (update_needed) {
        switch(active_selection) {
            
            case 1:
                lcd->cls();
                lcd->locate(1,0);
                lcd->printf("Resetting to Factory Default");
                lcd->locate(1,0);
                counter = 5;
                active_selection=2;
                update_needed=1;
                break;
                
            case 2:
                lcd->locate(2,0);
                lcd->printf("Please wait %d...", counter--);
                if (counter == 0) active_selection=0;
                update_needed=1;
                break;
            
            default:
                lcd->cls();
                lcd->locate(0,0);
                lcd->printf("Press <Set> to Reset");
                update_needed=0;
                break;
        };
    }
    
    displayCurrentTime(lcd);
    displayVersion(lcd);
}

/******************************************************************************/
void FactoryResetMenu::pressMode()
{
    // toggle active menu 
    switch(active_selection) {
        
        case 0:
            back();
            break;
        case 1:
            back();
            break;
            
        default:
            active_selection = 0;
            break;
    };

    update_needed = 1;
}

/******************************************************************************/
void FactoryResetMenu::pressSet()
{
    // set button advances to next character position OR
    // goes back to normal
    switch(active_selection) {
        
        case 0:
            active_selection = 1;
            addressMap.reset();
            escmEventLog.reset();
            break;
            
        case 1: // press yes
            active_selection = 2;
            break;
            
        case 2: // complete
            //back();
            active_selection = 0;
            break;
            
        default:
            active_selection = 0;
            break;
            
    };
    update_needed = 1;
}

/******************************************************************************/


