
/**************************************************************************
 * @file     EditTimeMenu.cpp
 * @brief    Base class for implementing the Edit Time Menu display
 * @version: V1.0
 * @date:    9/17/2019

 *
 * @note
 * Copyright (C) 2019 E3 Design. All rights reserved.
 *
 * @par
 * E3 Designers LLC is supplying this software for use with Cortex-M3 LPC1768
 * processor based microcontroller for the ESCM 2000 Monitor and Display.  
 *  *
 * @par
 * THIS SOFTWARE IS PROVIDED "AS IS".  NO WARRANTIES, WHETHER EXPRESS, IMPLIED
 * OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE.
 * ARM SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 ******************************************************************************/
#include "mbed.h"
#include "EditTimeMenu.h"
#include "TimeUtilities.h"

/******************************************************************************/
EditTimeMenu::EditTimeMenu(char* id): Menu(id)
{
   
    active_selection = 0;
    row=0;
    column=0;
    
    time_t rawtime;
    struct tm * timeinfo;
    
    time ( &rawtime );
    timeinfo = localtime ( &rawtime );  timeinfo = localtime (&rawtime);
                
    hours = timeinfo->tm_hour;
    mins  = timeinfo->tm_min;
    secs  = timeinfo->tm_sec;
    
    years   = timeinfo->tm_year + 1900;
    months  = timeinfo->tm_mon + 1 ;
    days    = timeinfo->tm_mday;
    
       
}
   

/******************************************************************************/
void EditTimeMenu::init()
{
    active_selection = 0;
    update_needed    = 1;
}


/******************************************************************************/
void EditTimeMenu::display(LCD * lcd) 
{
    char     setTime = 1;
    char     setDate = 1;
    
    char current[40];
    
    time_t rawtime;
    struct tm * timeinfo;
    
    int cur_hours,cur_mins,cur_secs,cur_year,cur_month,cur_day;
    
            
    time ( &rawtime );
    timeinfo = localtime ( &rawtime );  timeinfo = localtime (&rawtime);
    
    cur_hours   = timeinfo->tm_hour;
    cur_mins    = timeinfo->tm_min;
    cur_secs    = timeinfo->tm_sec;
    cur_year    = timeinfo->tm_year+1900;
    cur_month   = timeinfo->tm_mon + 1;
    cur_day     = timeinfo->tm_mday;
    
    
    
    
    if ( update_needed ) 
    {
        lcd->cls();
        
        lcd->locate(0,0);
         lcd->printf("Current Time/Date :");
        
        time ( &rawtime );
        timeinfo = localtime ( &rawtime );  timeinfo = localtime (&rawtime);
        
        if (!active_selection)
        {
            hours   = cur_hours;
            mins    = cur_mins;
            secs    = cur_secs;
            years   = cur_year;
            months  = cur_month;
            days    = cur_day;
            //lcd->setCursorMode (0) ;
        }
        else
        {
            
            // edit mode
            secs  = timeinfo->tm_sec;
            
            if ( hours < 12 ) {
                cur_hours = (hours == 0) ? 12 : hours;
        
            } else  {
                cur_hours = (hours - 12);
            }
        
            lcd->locate(2,0);
            switch(active_selection)
            {
              case 1:  

#if 1
                    if ( hours < 12 ) {
                        cur_hours = (hours == 0) ? 12 : hours;
                        lcd->printf("Set Time (hours)  :  %02dam", cur_hours);

                    } else  {
                        cur_hours = (hours - 12);
                        cur_hours = (cur_hours == 0) ? 12 : cur_hours;
                        
                        lcd->printf("Set Time (hours)  :  %02dpm", cur_hours);
                    }
#else
                    lcd->printf("Set Time (hours)  :  %02d", hours);
#endif
                 break;
              case 2:  
                 lcd->printf("Set Time (min)    :  %02d", mins);
                 break;
              case 3:  
                 lcd->printf("Set Time (sec)    :  %02d", secs);
                 break;
              case 4:  
                 lcd->printf("Set Date (month)  :  %02d", months);
                 break;
              case 5:  
                 lcd->printf("Set Date (day)    :  %02d", days);
                 break;
              case 6:  
                 lcd->printf("Set Date (year)   :  %02d", years);
                 break;
            default:
                break;
            };
        
            lcd->locate(3,0);
            lcd->printf("Updated Time      :");
#if 1

            if ( hours < 12 ) {
        
                cur_hours = (hours == 0) ? 12 : hours;
                cur_hours = (cur_hours == 0) ? 12 : cur_hours;
                lcd->locate(3,20);
                lcd->printf(" %02d:%02d:%02dam %02d/%02d/%02d",
                            cur_hours, mins, secs, months, days, (years%100));
        
            } else  {
        
                cur_hours = (hours - 12);
                cur_hours = (cur_hours == 0) ? 12 : cur_hours;
                lcd->locate(3,20);
                lcd->printf(" %02d:%02d:%02dpm %02d/%02d/%02d",
                            cur_hours, mins, secs, months, days, (years%100));
        
        
            }
#else
            lcd->locate(3,20);
            lcd->printf(" %02d:%02d %02d/%02d/%04d", hours, mins, months, days, years);

#endif    
            
        
        }
        
        update_needed = 0;
    }
    displayCurrentTime(lcd);
    

        
}

/******************************************************************************/
void EditTimeMenu::pressMode()
{   
    // advance thru
    if (active_selection++ >  6 )
    {
        active_selection = 0;  
    }
    
    update_needed = 1;
}
        
/******************************************************************************/
void EditTimeMenu::pressSet()
{
    
    struct tm t;
    
    t.tm_hour = hours;
    t.tm_min  = mins;
    t.tm_sec  = 0;
    
    t.tm_year = years - 1900;
    t.tm_mon  = months - 1;
    t.tm_mday = days;
    
    // set the time
    set_time(mktime(&t));

   
    // go back to normal display
    // ---------------------------------
    active_selection = 0;
    update_needed = 1;
}

/******************************************************************************/
void EditTimeMenu::pressUp()
{    
    switch(active_selection)
    {
        case 1: hours++;break;
        case 2: mins++;break;
        case 3: secs++;break;
        case 4: months++;break;
        case 5: days++;break;
        case 6: years++;break;
        default:break;
        
    }
    if (hours > 23)    hours  = 0;
    if (mins > 60)     mins   = 0;
    if (secs > 60)     secs   = 0;
    if (months > 12)   months  = 1;
    if (days > 31)     days    = 1;
    if (years > 2050) years  =2011;
    
    update_needed = 1;
}
        
/******************************************************************************/
void EditTimeMenu::pressDown()
{
    switch(active_selection)
    {
        case 1: hours--;break;
        case 2: mins--;break;
        case 3: secs--;break;
        case 4: months--;break;
        case 5: days--;break;
        case 6: years--;break;
        default:break;
        
    }
    
    if (hours < 0)    hours  += 23;
    if (mins < 0)     mins   += 60;
    if (secs < 0)     secs   += 60;
    if (months < 1)   months += 12;
    if (days < 1)     days   += 31;
    if (years < 2011) years  =2050;
        
    update_needed = 1;   
}
/******************************************************************************/
