/**************************************************************************
 * @file     Menu.h
 * @brief    Base class for wrapping the interface with LCD Menu display
 * @version: V1.0
 * @date:    9/17/2019

 *
 * @note
 * Copyright (C) 2019 E3 Design. All rights reserved.
 *
 * @par
 * E3 Designers LLC is supplying this software for use with Cortex-M3 LPC1768
 * processor based microcontroller for the ESCM 2000 Monitor and Display.  
 *  *
 * @par
 * THIS SOFTWARE IS PROVIDED "AS IS".  NO WARRANTIES, WHETHER EXPRESS, IMPLIED
 * OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE.
 * ARM SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 ******************************************************************************/
#ifndef MENU_H
#define MENU_H

#include "mbed.h"
#include "LCD.h"

#include <vector>
#include <string>


class Menu {
    private:
    
        Mutex display_mutex;
               
    public:
        static Menu * currentMenu;
        static Menu * getCurrentMenu () ;
        static Menu * setCurrentMenu (Menu * value) ;
        
        LCD  * lcd;
        
        
        int update_needed;
        
        int selectedMenu;  // what selection the cursor points to
        
        int cursorLine; // what line of the lcd the cursor is one
        int cursorIndex; // what line of the lcd the cursor is one
    
        Menu * parent;
        
        vector<Menu*> children;
        
        char* menuID;
        
        Menu(char *id);
        
        void add( Menu *submenu);
        
        virtual void init();
        virtual void select();
        virtual void back();
        
        virtual char* getText() { return "Main"; }
        
        virtual void DrawDisplay(LCD * lcd);
        virtual void display(LCD * lcd);
        void displayCurrentTime (LCD * lcd);
        void displayVersion (LCD * lcd);

        void moveUp();
        void moveDown();
        
        virtual void pressClear();  
        virtual void pressMode();        
        virtual void pressSet();    
        virtual void pressDown();    
        virtual void pressUp();
        
        virtual void lock()   { display_mutex.lock();}
        virtual void unlock() { display_mutex.unlock();}
        
};
#endif