/**************************************************************************
 * @file     DisplayCodeMenu.h
 * @brief    Base class for implementing the Display Code Menu display
 * @version: V1.0
 * @date:    9/17/2019

 *
 * @note
 * Copyright (C) 2019 E3 Design. All rights reserved.
 *
 * @par
 * E3 Designers LLC is supplying this software for use with Cortex-M3 LPC1768
 * processor based microcontroller for the ESCM 2000 Monitor and Display.  
 *  *
 * @par
 * THIS SOFTWARE IS PROVIDED "AS IS".  NO WARRANTIES, WHETHER EXPRESS, IMPLIED
 * OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE.
 * ARM SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 ******************************************************************************/
#include "mbed.h"
#include "Menu.h"
#include "LCD.h"
#include "ESCMControlApp.h"

#ifndef DISPLAYCODE_MENU_H
#define DISPLAYCODE_MENU_H

class DisplayCodesMenu : public Menu 
{
   public :
        int row;
        int column;
        int erase_log;
        
        int active_selection;
        int current_line;
        int current_index;
        int top;
        int bottom;
        
        DisplayCodesMenu(char* id);
   
        void display(LCD * lcd);
            
        virtual void pressMode();        
        virtual void pressSet();        
        virtual void pressDown();    
        virtual void pressUp();
        virtual void init();
        
        virtual char* getText() { return "Display Codes"; }
};


#endif