/**************************************************************************//**
 * @file     ButtonController.cpp
 * @brief    Base class for wrapping the interface with the GPIO Extender.
 * @version: V1.0
 * @date:    9/17/2019

 *
 * @note
 * Copyright (C) 2019 E3 Design. All rights reserved.
 *
 * @par
 * E3 Designers LLC is supplying this software for use with Cortex-M3 LPC1768
 * processor based microcontroller for the ESCM 2000 Monitor and Display.  
 *  *
 * @par
 * THIS SOFTWARE IS PROVIDED "AS IS".  NO WARRANTIES, WHETHER EXPRESS, IMPLIED
 * OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE.
 * ARM SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 ******************************************************************************/
#include "ButtonController.h"


/******************************************************************************/
ButtonController::ButtonController()
{
    
    spi_io_exp = new mcp23s08 (p5, p6, p7, p26, 0x20);
    
    // ---------------------------------------
    // set pin modes
    // ---------------------------------------
    spi_io_exp->gpioPinMode(0,0);
    spi_io_exp->gpioPinMode(1,0);
    spi_io_exp->gpioPinMode(2,0);
    spi_io_exp->gpioPinMode(3,0);
    spi_io_exp->gpioPinMode(4,0);
    spi_io_exp->gpioPinMode(5,1);
    spi_io_exp->gpioPinMode(6,1);
    spi_io_exp->gpioPinMode(7,1);
    
    // ---------------------------------------
    // enable the audio amplifier
    // ---------------------------------------
    spi_io_exp->gpioPinMode(5,1);
    spi_io_exp->gpioDigitalWrite(5,1);
    spi_io_exp->gpioDigitalWrite(6,0);
    spi_io_exp->gpioDigitalWrite(7,0);
    
}

/******************************************************************************/
ButtonController::~ButtonController()
{
    
}

/******************************************************************************/
void ButtonController::init(void)
{
    
}

/******************************************************************************/
void ButtonController::processCmdQueue(Menu * activeMenu)
{
    while (!cmd_queue.empty()) {
        
        uint8_t e;
        
        cmd_queue.pop(e);
        
        printf("\n<%02x>", e);

        switch(e) {
            case 0x01://up
                activeMenu->pressUp();
                break;

            case 0x02://down
                activeMenu->pressDown();
                break;

            case 0x04://clear
                activeMenu->pressClear();
                break;

            case 0x08://mode
                activeMenu->pressMode();
                break;

            case 0x10://set
                activeMenu->pressSet();
                break;
            default:
                break;
        }
    }
}


/******************************************************************************/
uint8_t ButtonController::getCurrentState()
{
    currentValue = spi_io_exp->readGpioPort();
    
    return currentValue;
}


/******************************************************************************/
void ButtonController::update(void)
{        

    int trigger_action = 0;
    
    currentValue = spi_io_exp->readGpioPort() ;
    currentValue = (~currentValue & 0x1F); // clear bit is stuck
    
    // if (raising edge | falling edge )
    if (currentValue != prevValue ) {
        prevValue = currentValue;
        countsSinceChange = 0;        
        trigger_action = 1;

    }
    else
    {   //TODO: play with time for what is short or long hold
        countsSinceChange++;
        if ( currentValue != NO_BUTTON && countsSinceChange>=10000)
        {
            if (isHeld != 2) printf("Button Long Held:%d\n\r",currentValue);
            isHeld = 2;
            trigger_action = 1;
            countsSinceChange = 0;
        }
        else if (currentValue != NO_BUTTON && countsSinceChange>=5000)
        {
            if (isHeld != 1) printf("Button Short Held:%d\n\r",currentValue);
            isHeld = 1;
            trigger_action = 1;
            countsSinceChange = 0;
        }
        else
        {
            isHeld =0;
        }
    }
    
    
    if (trigger_action)
    {    
        if (currentValue && !cmd_queue.full())  {
            cmd_queue.push(currentValue);
        }
        trigger_action = 0;
        
    }
}


/******************************************************************************/
void ButtonController::pressButtonUp(void)
{
    printf("Up Button Pressed:%d\n\r",currentValue);
}

/******************************************************************************/
void ButtonController::pressButtonDown(void)
{
    printf("Down Button Pressed:%d\n\r",currentValue);
}

/******************************************************************************/
void ButtonController::pressButtonSet(void)
{
    printf("Set Button Pressed:%d\n\r",currentValue);
}

/******************************************************************************/
void ButtonController::pressButtonMode(void)
{
    printf("Mode Button Pressed:%d\n\r",currentValue);
}

/******************************************************************************/
void ButtonController::pressButtonClear(void)
{
    printf("Clear Button Pressed:%d\n\r",currentValue);
}

/******************************************************************************/
void ButtonController::releaseButton(void)
{
    //printf("Button Released:%d\n\r",currentValue);
    isHeld = 0;
    countsSinceChange = 0;
}
/******************************************************************************/
