/**************************************************************************//**
 * @file     AddressMap.h
 * @brief    Base class for storage of Address Mapping data.
 * @version: V1.0
 * @date:    9/17/2019

 *
 * @note
 * Copyright (C) 2019 E3 Design. All rights reserved.
 *
 * @par
 * E3 Designers LLC is supplying this software for use with Cortex-M3 LPC1768
 * processor based microcontroller for the ESCM 2000 Monitor and Display.  
 *  *
 * @par
 * THIS SOFTWARE IS PROVIDED "AS IS".  NO WARRANTIES, WHETHER EXPRESS, IMPLIED
 * OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE.
 * ARM SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 ******************************************************************************/
#ifndef _ADDRESS_MAP_
#define _ADDRESS_MAP_

#include "mbed.h"

#define  MAX_ADDR_LENGTH 20
#define  MAX_ADDRESSES   100

class Address
{
public:

    int address;
    char description[MAX_ADDR_LENGTH];
    
    Address () {
    }
    
    Address (const Address &obj) {
        // body of constructor
        address     = obj.address;
        strcpy(description, obj.description);
    }
    
    Address operator=(const Address& b) {
        Address a (b);
        return a;
    }

};

class AddressMap
{

public:

    Address addresses[MAX_ADDRESSES];

    int reset();
    int init();
    int load();
    int save();
    
    void display(Serial *pc);
    
    char* getDescription(unsigned char idx );

};

#endif