/*Connect as follows:

Power supply MUST BE 3.3V and GND to the respective pins.

  RFID pins          ->   Board pinName   L432KC       FRDM-KL25Z
  ---------------------------------------------------------------------
  
  =======================  BUS   ======================================
  RFID MISO = pin4   ->   SPI_MISO        PA_6=D12     PTD3
  RFID MOSI = pin3   ->   SPI_MOSI        PA_7=D11     PTD2
  RFID SCK  = pin2   ->   SPI_SCK         PA_5=D13     PTD1
  ======================= RFID 1 ====================================== 
  RFID SDA  = pin1   ->   SPI_CS          PB_6=D10     PTD0
  RFID RST  = pin7   ->                   PA_9=D8      PTA13
  RFID IRQ  = pin5   ->                   -------- OPEN --------
  ======================= RFID 2 ======================================
  RFID SDA  = pin1   ->   SPI_CS          PA_12=D2     PTD5     
  RFID RST  = pin7   ->                   PB_1=D6      PTC9
  RFID IRQ  = pin5   ->                   -------- OPEN --------
  =====================================================================

Connecting the "HOUSE"
  Location      Circuit latch function    L432KC       FRDM-KL25Z
  ---------------------------------------------------------------------
  Front door    Set                       A1           A1
  Front door    Reset                     A2           A2
  Room 1 door   Set                       A3           A3
  Room 1 door   Reset                     A4           A4
  =====================================================================
  
  Mapping:
  Front door = r0 = rfid0
  Room 1 door = r1 = rfid1
  
*/

#include "mbed.h"
#include "MFRC522.h"

#ifndef COMPILING_FOR_KL25Z
    #define COMPILING_FOR_KL25Z 1 //Set this to 1 to compile with KL25Z pins
#endif


#ifndef PINSETTINGS_H
#define PINSETTINGS_H

    #if COMPILING_FOR_KL25Z
      // FRDM KL25Z pins
      
      //USB communication
      #define SERIAL_TX PTE0  //UART0 USB
      #define SERIAL_RX PTE1  //UART0 USB
      
      //BUS
      #define SPI_MISO  PTD3
      #define SPI_MOSI  PTD2
      #define SPI_SCK   PTD1
      
      //RFID 1
      #define SPI_CS1   PTD0  //Chip select can be any digital pin
      #define MF_RESET1 PTA13
      
      //RFID 2
      #define SPI_CS2   PTD5
      #define MF_RESET2 PTC9
    
      //House circuit connections
      #define FRONTDOOR_SET A1
      #define FRONTDOOR_RST A2
      #define ROOM1DOOR_SET A3
      #define ROOM1DOOR_RST A4
    
    #else
      // STM32 L432KC pins
      
      //USB communication
      #define SERIAL_TX USBTX  //UART0 USB
      #define SERIAL_RX USBRX  //UART0 USB
      
      //BUS
      #define SPI_MISO  D12
      #define SPI_MOSI  D11
      #define SPI_SCK   D13
      
      //RFID 1
      #define SPI_CS1   D10
      #define MF_RESET1  D8
      
      //RFID 2
      #define SPI_CS2    D2
      #define MF_RESET2  D6
    
      //House circuit connections
      #define FRONTDOOR_SET A1
      #define FRONTDOOR_RST A2
      #define ROOM1DOOR_SET A3
      #define ROOM1DOOR_RST A4
    
    #endif
#endif