/****************************************************
*            FAST PROTOTYPING WITH NUCLEO           *
* Example Code 14: DC motor control con Procedura   *
* Author: Francesco Caiazzo                         *
* Organization: Perlatecnica no-profit organization *  
*****************************************************/

#include "mbed.h"
#define P 10000 // periodo

PwmOut mB1(D10);
PwmOut mB2(D11);

void motore(int speed) //funzione muove motore
{
    speed *= 100;   //adatto il duty cycle
    
    if (speed > 0) //controllo se speed > 0
    {
        // Avanti
        mB1.pulsewidth_us(0);
        mB2.pulsewidth_us(speed);
    }
    else if (speed < 0)
    {
        // Dietro
        mB2.pulsewidth_us(0);
        mB1.pulsewidth_us(-speed); // rendo positiva la velocità
    }
    else
    {
        // Stop
        mB2.pulsewidth_us(0);
        mB1.pulsewidth_us(0);
    }
    

}

int main() 
{
    //setto il periodo per i due pin del motore B
    mB1.period_us(P);
    mB2.period_us(P);
    
    while(1)
    {
        motore(100);    // avanti a v = 100
        wait(1);        // aspetto 1s
        motore(0);      // mi fermo
        wait(1);        // aspetto 1s 
        motore(-100);   // dietro a v = 100
        wait(1);        // aspetto 1s
        motore(0);      // mi fermo
        wait(1);        // aspetto 1s
    }
}