#include "mbed.h"
#include "MotorShieldIHM12A1.h"
#include "hcsr04.h"

#define SPEED   40
#define Kp      50
#define offset  0
#define sample  5

float DIR; 
float mediaB = 0;
float mediaN = 0 ;
float mediaT = 0;

HCSR04 sensor(D10, D11);
Serial pc(USBTX, USBRX);
 
MotorShieldIHM12A1 ms;
AnalogIn lineaD(A5);
DigitalIn pulsante(PC_13);

int main()
{
    pc.baud(9600);
    pc.printf("Here I am!\r\n");
    printf("start Seguilinea.os\r\n");
    
    printf ("Robot su Bianco\r\n ");
    while (pulsante) 
    {
        wait (0.1);
    }
    wait(0.1);
    
    for (int i=0; i<5; i++)
    {
        mediaB += lineaD.read();
        wait(0.1);
    }
    
    mediaB /= sample;
    printf("Bianco: %f\r\n",mediaB);
    
    printf ("Robot su Nero\r\n ");
    while (pulsante) 
    {
        wait (0.1);
    }
    wait(0.1);
    
    for (int i=0; i<sample; i++) 
    {
        mediaN += lineaD.read();
        wait(0.1);
    }
    mediaN /= sample;
    printf("Nero: %f\r\n",mediaN);
    
    mediaT =(mediaB+mediaN) / 2;
    printf("Offset: %f\r\n",mediaT);
    
    while (pulsante) 
    {
        wait (0.1);
    }
    wait(0.1);
    
    
    while(true) 
    {
        // Avvia un impulso della durata di 10us sul pin di trigger
        sensor.start();
        
        // Aspetta prima della prossima lettura
        wait_ms(300); 
        
        // Stampa sulla seriale la misura della distanza in cm
        pc.printf("%dcm\r\n", sensor.get_dist_cm());
        
        if (sensor.get_dist_cm() > 20)
        {
            ms.turn((lineaD.read()-mediaT)*Kp,SPEED); 
        }
        else
        {
            ms.turn(0,0);
        }
             
    }
}