#include "MotorShieldIHM12A1.h"
#include "mbed.h"
 
 
/* Variables -----------------------------------------------------------------*/
 
/* Initialization parameters of the motor connected to the expansion board. */
 Stspin240_250_Init_t initDeviceParameters = {
  20000, /* Frequency of PWM of Input Bridge A in Hz up to 100000Hz             */
  20000, /* Frequency of PWM of Input Bridge B in Hz up to 100000Hz             */
  20000, /* Frequency of PWM used for Ref pin in Hz up to 100000Hz              */
  50,    /* Duty cycle of PWM used for Ref pin (from 0 to 100)                  */
  TRUE   /* Dual Bridge configuration  (FALSE for mono, TRUE for dual brush dc) */
 };
 
/* Motor Control Component. */
STSPIN240_250 *motor;
 
/* Functions -----------------------------------------------------------------*/
void myErrorHandler(uint16_t error)
{
  /* Printing to the console. */
  printf("Error %d detected\r\n\n", error);
  
  /* Infinite loop */
  while(1)
  {
  }    
}
 
void myFlagIRQHandler(void)
{
 
  printf("    WARNING: \"FLAG\" interrupt triggered.\r\n");
 
  /* Get the state of bridge A */
  uint16_t bridgeState  = motor->GetBridgeStatus(0);
  
  if (bridgeState == 0) 
  {
    if (motor->GetDeviceState(0) != INACTIVE)
    {
      /* Bridges were disabled due to overcurrent or over temperature */
      /* When  motor was running */
        myErrorHandler(0XBAD0);
    }
  }
}
 
MotorShieldIHM12A1::MotorShieldIHM12A1()
{
    
//----- Initialization 
  
  /* Initializing Motor Control Component. */
  #if (defined TARGET_NUCLEO_F030R8)||(defined TARGET_NUCLEO_F334R8)
  motor = new STSPIN240_250(D2, D9, D6, D7, D5, D4, A2);
  #elif (defined TARGET_NUCLEO_L152RE)
  motor = new STSPIN240_250(D2, D9, D6, D7, D5, D4, A3);
  #else
  motor = new STSPIN240_250(D2, D9, D6, D7, D5, D4, A0);
  #endif
  if (motor->Init(&initDeviceParameters) != COMPONENT_OK) exit(EXIT_FAILURE);
 
  /* Set dual bridge enabled as two motors are used*/
  motor->SetDualFullBridgeConfig(1);
 
  /* Attaching and enabling an interrupt handler. */
  motor->AttachFlagIRQ(&myFlagIRQHandler);
  motor->EnableFlagIRQ();
    
  /* Attaching an error handler */
  motor->AttachErrorHandler(&myErrorHandler);
 
  /* Set PWM Frequency of Ref to 15000 Hz */ 
  motor->SetRefPwmFreq(0, 15000); 
 
  /* Set PWM duty cycle of Ref to 60% */ 
  motor->SetRefPwmDc(0, 60); 
  
  /* Set PWM Frequency of bridge A inputs to 10000 Hz */ 
  motor->SetBridgeInputPwmFreq(0,10000); 
  
  /* Set PWM Frequency of bridge B inputs to 10000 Hz  */ 
  motor->SetBridgeInputPwmFreq(1,10000); 
  
}
 
void MotorShieldIHM12A1::motorSpeed(unsigned int ID, int8_t speed)
{ 
    if  (speed > 100)   speed = 100;
    else if (speed < -100)  speed = -100;
      
    if (speed>0)
    {
        motor->SetSpeed(ID,speed); 
        motor->Run(ID, BDCMotor::FWD);
    }
    else if (speed<0)
    {
        motor->SetSpeed(ID,-speed); 
        motor->Run(ID, BDCMotor::BWD);
    }
    else
    {
        motor->HardStop(ID);
    } 
}
 
void MotorShieldIHM12A1::motorStop(unsigned int ID)
{
    motor->HardHiZ(ID);       
}
 
void MotorShieldIHM12A1::motorReset()
{
    motor->Reset();
}
 
void MotorShieldIHM12A1::turn(int8_t direction, int8_t speed)
{
    bool left = false;
    float speedMod;
    
    if (direction < 0)
    {
        left = true;
        direction = -direction;
    }
 
    speedMod = ((float)speed/100)*(direction-50)*(-2);
    
    if (left)
    {
        
        motorSpeed(1,speedMod);
        motorSpeed(0,speed);
    }
    else
    {
        motorSpeed(0,speedMod);
        motorSpeed(1,speed);
    }
}