#include "mbed.h"
#include "stspin240_250_class.h"

/* Initialization parameters of the motor connected to the expansion board. */
 Stspin240_250_Init_t initDeviceParameters =
 {
  20000, /* Frequency of PWM of Input Bridge A in Hz up to 100000Hz             */
  20000, /* Frequency of PWM of Input Bridge B in Hz up to 100000Hz             */
  20000, /* Frequency of PWM used for Ref pin in Hz up to 100000Hz              */
  50,    /* Duty cycle of PWM used for Ref pin (from 0 to 100)                  */
  TRUE   /* Dual Bridge configuration  (FALSE for mono, TRUE for dual brush dc) */
 };

/* Motor Control Component. */
STSPIN240_250 *motor;

int main()
{
  uint8_t demoStep = 0;

  /* Initializing Motor Control Component. */
  #if (defined TARGET_NUCLEO_F030R8)||(defined TARGET_NUCLEO_F334R8)
  motor = new STSPIN240_250(D2, D9, D6, D7, D5, D4, A2);
  #elif (defined TARGET_NUCLEO_L152RE)
  motor = new STSPIN240_250(D2, D9, D6, D7, D5, D4, A3);
  #else
  motor = new STSPIN240_250(D2, D9, D6, D7, D5, D4, A0);
  #endif
  if (motor->Init(&initDeviceParameters) != COMPONENT_OK) exit(EXIT_FAILURE);

  /* Set dual bridge enabled as two motors are used*/
  motor->SetDualFullBridgeConfig(1);


  /* Set PWM Frequency of Ref to 15000 Hz */ 
  motor->SetRefPwmFreq(0, 15000); 

  /* Set PWM duty cycle of Ref to 60% */ 
  motor->SetRefPwmDc(0, 60); 
  
  /* Set PWM Frequency of bridge A inputs to 10000 Hz */ 
  motor->SetBridgeInputPwmFreq(0,10000); 
  
  /* Set PWM Frequency of bridge B inputs to 10000 Hz */ 
  motor->SetBridgeInputPwmFreq(1,10000); 
  
  while (1)
  {
    switch (demoStep)
    {  
        case 0:
          /* Set speed of motor 0 to 100 % */
          motor->SetSpeed(0,50);
          motor->SetSpeed(1,50); 
          /* start motor 0 to run forward*/
          /* if chip is in standby mode */
          /* it is automatically awakened */
          motor->Run(0, BDCMotor::FWD);
          motor->Run(1, BDCMotor::FWD);
          break;
                  case 1:
                  /* Set speed of motor 0 to 100 % */
                motor->SetSpeed(0,50);
                motor->SetSpeed(1,50); 
                /* start motor 0 to run forward*/
                /* if chip is in standby mode */
                /* it is automatically awakened */
                motor->Run(0, BDCMotor::BWD);
                motor->Run(1, BDCMotor::BWD);
                break;
                   case 2:
                  /* Set speed of motor 0 to 100 % */
                motor->SetSpeed(0,32);
                motor->SetSpeed(1,25); 
                /* start motor 0 to run forward*/
                /* if chip is in standby mode */
                /* it is automatically awakened */
                motor->Run(0, BDCMotor::BWD);
                motor->Run(1, BDCMotor::BWD);
                break;
                    case 3:
                  /* Set speed of motor 0 to 100 % */
                motor->SetSpeed(0,25);
                motor->SetSpeed(1,40); 
                /* start motor 0 to run forward*/
                /* if chip is in standby mode */
                /* it is automatically awakened */
                motor->Run(0, BDCMotor::BWD);
                motor->Run(1, BDCMotor::BWD);
                break;
          
          
            
                 
    }
  
    /* Wait for 5 seconds */  
    wait_ms(5000);
    
    /* Increment demostep*/  
    demoStep++;
    if (demoStep > 12)
    {
      demoStep = 0;
    }
  } 
}

