/* mbed RGB Matrix Library
 * Written for Nucleo-F446RE, v1.0, 03-10-2015
 *
 * Copyright (c) 2013-2015 JackB, cstyles
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
  
#ifndef MBED_RGB_MATRIX_H
#define MBED_RGB_MATRIX_H
 
#include "mbed.h"
#include "math.h"
//#include "GraphicsDisplay.h"

/** RGB_Matrix calculation class
 *
 * Example:
 * @code
 * // Continuously sweep the RGB_Matrix through it's full range
 * #include "mbed.h"
 * #include "RGB_Matrix.h"
 * 
 * RGB_Matrix myRGB_Matrix(LED1,LED2,LED3);
 *
 * int main() {
 *     myRGB_Matrix.SetS(1.0);
 *     myRGB_Matrix.SetV(1.0);
 *     while(1) {
 *         for(int i=0; i<100; i++) {
 *             myRGB_Matrix.SetH((float)i/100.0);
 *             myRGB_Matrix.RGB_Matrix_to_RGB();
 *             wait(0.01);
 *         }
 *     }
 * }
 * @endcode
 */

#define ROWS 16
#define PLANES 7
#define WIDTH 64
#define HEIGHT 32
#define PIXELS 2048 // WIDTH * HEIGHT
#define DBUF true
#define LANDSCAPE_T 0
#define PORTRAIT_L 1
#define LANDSCAPE_B 2
#define PORTRAIT_R 3

#define BYTESPERCHAR  0
#define FONTWIDTH     1
#define FONTHEIGHT    2
#define BYTESPERLINE  3

#define INTTIME 0.00012 // 0.0003 is slowest, 0.00007 is fastest, Nr2 0.000001 is fastest

#define RGB(r,g,b)  (((r&0xF8)<<8)|((g&0xFC)<<3)|((b&0xF8)>>3)) //5 red | 6 green | 5 blue


/* some RGB color definitions 
                        
                        RRRR RGGG GGGB BBBB
*/
#define Black           0x0000      /*   0,   0,   0 */
#define Navy            0x000F      /*   0,   0, 128 */
#define DarkBlue        0x000F      /*   0,   0, 255 */
#define DarkGreen       0x03E0      /*   0, 128,   0 */
#define DarkCyan        0x03EF      /*   0, 128, 128 */
#define Maroon          0x7800      /* 128,   0,   0 */
#define Purple          0x780F      /* 128,   0, 128 */
#define Olive           0x7BE0      /* 128, 128,   0 */
#define LightGrey       0xC618      /* 192, 192, 192 */
#define Grey            0x7BEF      /* 128, 128, 128 */
#define DarkGrey        0x4208      /*  64,  64,  64 01000 010000 01000 */
#define Blue            0x001F      /*   0,   0, 255 */
#define Green           0x07E0      /*   0, 255,   0 */
#define Cyan            0x07FF      /*   0, 255, 255 */
#define Red             0xF800      /* 255,   0,   0 */
#define Magenta         0xF81F      /* 255,   0, 255 */
#define Yellow          0xFFE0      /* 255, 255,   0 */
#define White           0xFFFF      /* 255, 255, 255 11111 111111 11111 */
#define Orange          0xFD20      /* 255, 165,   0 11111 101001 00000 */
#define GreenYellow     0xAFE5      /* 173, 255,  47 10101 111111 00101 */


class RGB_Matrix 
//class RGB_Matrix : public GraphicsDisplay
{
public:
  
  /** Create a RGB_Matrix object
   *
   * @param void 
   */
    RGB_Matrix(PinName Pin_R1, PinName Pin_R2, PinName Pin_G1, PinName Pin_G2, 
             PinName Pin_B1, PinName Pin_B2, 
             PinName Pin_CLK, PinName Pin_LAT, PinName Pin_OE, 
             PinName Pin_A, PinName Pin_B, PinName Pin_C, PinName Pin_D);

    void Init(void);
    
    void swap(int16_t &x, int16_t &y);
    uint16_t rgbToColor(uint8_t R, uint8_t G, uint8_t  B);

    void drawPixel2(int16_t x, int16_t y, uint16_t c);
    void drawPixel(int16_t x, int16_t y, uint16_t c);

    void set_font(unsigned char* f);
    
    void character(int x, int y, int c);

    int putc(int value);
    void printString(char *string);
    void printStringCenter(char *string);
    
    void foreground(uint16_t colour);
    void background(uint16_t colour);
    int width();
    int height();
    void SetOrientation(uint8_t orientation);
    void locate(uint8_t x, uint8_t y);
    void locatePixelX(uint8_t x);
    void locatePixelY(uint8_t y);

    int columns();
    int rows();

    void setDisplayBuffer(uint8_t Buffer);
    void setWriteBuffer(uint8_t Buffer);

    void updateDisplay(void);
    void updateDisplay2(void);

private:

    DigitalOut _Pin_R1; 
    DigitalOut _Pin_R2; 
    DigitalOut _Pin_G1; 
    DigitalOut _Pin_G2; 
    DigitalOut _Pin_B1; 
    DigitalOut _Pin_B2; 
    DigitalOut _Pin_CLK; 
    DigitalOut _Pin_LAT; 
    DigitalOut _Pin_OE; 
    DigitalOut _Pin_A; 
    DigitalOut _Pin_B; 
    DigitalOut _Pin_C; 
    DigitalOut _Pin_D; 

    Ticker Update;

  // Counters/pointers for interrupt handler:
  uint8_t row, plane, bufferDisplay, bufferWrite;
//  uint8_t PixelValueR1, PixelValueG1, PixelValueB1;
//  uint8_t PixelValueR2, PixelValueG2, PixelValueB2;
  uint8_t *buffptr;
//  volatile uint8_t backindex;
//  volatile bool swapflag;

    uint8_t         *matrixbuff[2];
//    uint8_t         pixelbuff0[WIDTH*HEIGHT*PLANES];
//    uint8_t         pixelbuff1[WIDTH*ROWS*PLANES];

  unsigned char* font;
  uint8_t char_x;
  uint8_t char_y;
  uint16_t _foreground, _background;
  uint8_t _orientation;

// Code for matrix pixel pwm 



};

#endif

