#include "mbed.h"
#include "rtos.h"
#include "DuckieTownCar.h"

/*
* Utilizzo il RTOS-MBED! perchè?
* Perchè ho la necessità di avere le info dai sensori senza essere bloccante
*/

DuckieTownCar* car = DuckieTownCar::getInstance();

Mutex car_mutex; 
 
void update_car(void const *args){
    car_mutex.lock();
    car->updateStateCar();
    car_mutex.unlock();
}

int main(){
    Thread th_update(update_car);
    car_mutex.lock();
    car->initCarSensor();
    car_mutex.unlock();
    
    car->executeRandom();
    return 0;    
}