#ifndef _DUCKIETOWNCAR_H
#define _DUCKIETOWNCAR_H

#include "ByteCode.h"
//#include "color.h"
#include "x_nucleo_iks01a2.h"

/***********************************************
*  DuckieTownCarHS     macchina Virtuale!      *
*  by De Angelis Domenico Francesco            *
*-------->      UNINA FabLAB      <------------*
************************************************/

//Se con le classi siamo nel torno, è meglio sbagliare alla grande! :D

#define DEBUG_CAR

//Singleton
class DuckieTownCar
{
private:
    static DuckieTownCar* instance;//istanza della macchina
    ByteCode code;

    LSM6DSLSensor *acc_gyro;//giroscopio
    int32_t axes[3],off[3];
    float parziale_angolo[3],angolo[3];//angolo indica di quanto sia ruotato rispetto ad offset iniziale in [gyro/d]
    //sceda per i motori
    
    //scheda dei Colori TCS3200
    //ColorSensor sensor_color;
    
    DuckieTownCar();
    
    void infoAxes();//aggiorna i valori di angolo!
    
    void dritto();
    void gira();
public:
    ~DuckieTownCar(){error("Ora mi devi spiegare come ci sei arrivato qui...\n");}
    static DuckieTownCar* getInstance();
    
    void initCarSensor();
    __forceinline void updateStateCar();//aggiorno lo stato della macchina attraverso i sensori!
    __forceinline void readMission(const ByteCode& codice){this->code.code = codice.code; this->code.dim_code = codice.dim_code;}
    void execute() const;
    void executeLine(unsigned char code) const;
    void executeRandom() const;

    //nel caso vogliamo permettere di configurare l'auto
    //void setVel(float);
    //float getVel() const;
};

#endif