/** mbed TerminalPlus Library, for ANSI/VT200 Terminals and ecape codes
 * Copyright (c) 2015, Max Scordamaglia , https//developer.mbed.org/users/MaxScorda/
 * fork from Terminal Library
 * Copyright (c) 2007-2010, sford, http://mbed.org
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


/*
Porre il terminate in VT100 e set di caratteri cp437
*/

#include "Terminal.h"
#include "mbed.h"

Terminal::Terminal(PinName tx, PinName rx) : Serial(tx, rx) {}

void Terminal::cls()
{
    this->printf("\033[2J");
}

void Terminal::locate(int column, int row)
{
    // Cursor Home    <ESC>[{ROW};{COLUMN}H

    //  this->printf("\033[%d;%dH%c", row + 1, column + 1); //original
    this->printf("\033[%d;%dH", row+1 , column+1 );
}

static int rgb888tobgr111(int colour)
{
    int r = (colour >> 23) & 1;
    int g = (colour >> 15) & 1;
    int b = (colour >> 7) & 1;
    return (b << 2) | (g << 1) | (r << 0);
}

void Terminal::foreground(int colour)
{
    // Set Attribute Mode    <ESC>[{n}m
    // Foreground Colours : 30 + bgr
    int c = 30 + rgb888tobgr111(colour);
    this->printf("\033[%dm", c);
}

void Terminal::forgcol(int color)
{
    /*colori da 0 a 7
    [ 3 0 m setaf 0 Set foreground to color #0 - black
    [ 3 1 m setaf 1 Set foreground to color #1 - red
    [ 3 2 m setaf 2 Set foreground to color #2 - green
    [ 3 3 m setaf 3 Set foreground to color #3 - yellow
    [ 3 4 m setaf 4 Set foreground to color #4 - blue
    [ 3 5 m setaf 5 Set foreground to color #5 - magenta
    [ 3 6 m setaf 6 Set foreground to color #6 - cyan
    [ 3 7 m setaf 7 Set foreground to color #7 - white
    [ 3 9 m setaf 9 Set default color as foreground color
    */

    if ((color<0) || (color>7)) color =7; //normalizza
    color=color+30;
    this->printf("\033[%dm", color);
}

void Terminal::bckgcol(int color)
{
    /*colori da 0 a 7
    [ 4 0 m setab 0 Set background to color #0 - black
    [ 4 1 m setab 1 Set background to color #1 - red
    [ 4 2 m setab 2 Set background to color #2 - green
    [ 4 3 m setab 3 Set background to color #3 - yellow
    [ 4 4 m setab 4 Set background to color #4 - blue
    [ 4 5 m setab 5 Set background to color #5 - magenta
    [ 4 6 m setab 6 Set background to color #6 - cyan
    [ 4 7 m setab 7 Set background to color #7 - white
    [ 4 9 m setaf 9 Set default color as background color
    */

    if ((color<0) || (color>7)) color =0; //normalizza
    color=color+40;
    this->printf("\033[%dm", color);
}


void Terminal::background(int colour)
{
    // Set Attribute Mode    <ESC>[{n}m
    // Background Colours : 40 + bgr
    int c = 40 + rgb888tobgr111(colour);
    this->printf("\033[%dm", c);
}

void Terminal::reset()
{
    // Reset Screen
    this->printf("\033c");
}

void Terminal::eraseline()
{
    // Erase full line, cursor save
    this->printf("\033[2K");
}

void Terminal::erasesquare(int x1, int y1, int x2, int y2)
{
   // cancella un quadrato dello schermo
   for(int i=y1; i<y2; i++) {
    //formatPrintf("*",x1,i,x2-x1);
    formatPrintf(string2char(padstr(" ",x2-x1,' ')),x1,i);
    }
    
}
void Terminal::resetattrib()
{
    // reset attrib
    this->printf("\033[0m");
}

void Terminal::bold()
{
    // font bold
    this->printf("\033[1m");
}

void Terminal::underscore()
{
    // underscore
    this->printf("\033[4m");
}

void Terminal::blink()
{
    // font blink
    this->printf("\033[5m");
}

void Terminal::reverse()
{
    // font reverse
    this->printf("\033[7m");
}
//*************************************
void Terminal::formatPrintf(char sstr[], int xx, int yy, int padb, bool boldf )
{
    int i=0; //mettere lungo come stringa
    //string tempstr=string(sstr);
    int screenColumn=78; //per ora lo forziamo

    locate(xx, yy);
    if (boldf==1) bold();
    this->puts(sstr);
    if (yy!=23) this->printf("\033[1A"); // fa davvero cagare. Torna su col cursore per evitare il \n eccetto l'ultima riga. Servirebbe togliere il \n
    while ((sstr[i]!='\n') && (i<(screenColumn-xx+1))) {
        i++;
    }

    //prosegui col pad
    while ((padb>0) && (i<(screenColumn-xx-1))) {
        this->printf(" "); //migliorare con stringa unica
        i++;
        padb--;
    }
    if (boldf==1) resetattrib();
}


void Terminal::frame(int x, int y, int w, int h, int boxtype)
{
    char B_H=0, B_V=0, B_TL=0, B_TR=0, B_BL=0, B_BR=0 ;
    // draw frame
    // BLOCK=219; SE SI VORRA' USARE IL FILL
    switch (boxtype) {
        case 0: //singolo
            B_H  =196;
            B_V  =179;
            B_TL =218;
            B_TR =191;
            B_BL =192;
            B_BR =217;
            break;

        case 1: //doppio
            B_H  =205;
            B_V  =186;
            B_TL =201;
            B_TR =187;
            B_BL =200;
            B_BR =188;
            break;

        case 2: //misto 1
            B_H  =196;
            B_V  =186;
            B_TL =214;
            B_TR =183;
            B_BL =212;
            B_BR =189;
            break;
    }

    //riga superiore
    formatPrintf(createStr(B_TL) ,x,y);
    formatPrintf(string2char(padstr("\n",78,char(B_H))),x+1,y);
    //for(int i=x+1; i<x+w; i++) formatPrintf(&B_H,i,y);
    formatPrintf(createStr(B_TR),x+w,y);
    //corpo
    for(int i=y+1; i<y+h; i++) {
        formatPrintf(createStr(B_V),x,i);
        formatPrintf(createStr(B_V),x+w,i);
    }
    //riga inferiore
    formatPrintf(createStr(B_BL),x,y+h);
    // for(int i=x+1; i<x+w; i++) formatPrintf(&B_H,i,y+h);
    formatPrintf(string2char(padstr("\n",78,char(B_H))),x+1,y+h);
    formatPrintf(createStr(B_BR),x+w,y+h);
}

void Terminal::readypos()
{
    locate(11, 23);
    //this->printf("Command: > ");
}


//------------------------------------------------
string Terminal::padstr(string sttde, int maxlen, char fillchar)
{
    bool flagEOS=false;
    string ret=sttde;
    if (ret.size()>0) {
        //se ha EOS lo tolgo
        if (ret.substr(ret.size()-1,1) == "\n") {
            ret=ret.substr(0,ret.size()-1);
            flagEOS=true;
        }
        //pad
        if (maxlen> ret.size()) ret.insert(ret.size(), maxlen - ret.size(), fillchar);
        //se aveva EOS, lo rimetto
        if (flagEOS==true) ret=addEOS(ret);
    }
    return ret;
}

string Terminal::addEOS(string sttde)
{
    string ret=sttde;
    if (sttde.substr(sttde.size()-1,1) != "\n") ret=sttde+"\n";
    return ret;
}

char* Terminal::string2char(string sttde)
{
    //ora aggiunge comunque l'EOS. Decidere se parametrizzare
    sttde=addEOS(sttde);
    char *cstr = new char[sttde.length() + 1];
    strcpy(cstr, sttde.c_str());
    // delete [] cstr;
    return cstr;
}

char* Terminal::createStr(char car)
{
    // unico modo in cui passo un varole ascii ad una funzione aggiungendo il ritorno a capo.
    //se si potesse evitare sarebbe meglio
    char *str = (char *) malloc(2 * sizeof(char));
    if(str == NULL) return NULL;
    str[0] = car;
    str[1] = '\0';
    return str;
}