// os.mbed.com/teams/ST/code/BSP_DISCO_F746NG/docs/tip/stm32746g__discovery__lcd_8c.html
// https://os.mbed.com/handbook/Socket
#include "mbed.h"
#include <string>
#include <ctype.h>
#include "EthernetInterface.h"


#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"

#include "button_group.hpp"
#include "Arduino.h"
using namespace ButGrp;
TS_DISCO_F746NG ts_;
LCD_DISCO_F746NG BSP_LCD_;

Ticker GestioneOutput;

//sensors
AnalogIn adc_temp(ADC_TEMP);
AnalogIn adc_vref(ADC_VREF);
#if defined(TARGET_DISCO_F051R8) || defined(TARGET_NUCLEO_F030R8) || defined(TARGET_NUCLEO_F031K6) || defined(TARGET_NUCLEO_F042K6) || defined(TARGET_NUCLEO_F070RB) || defined(TARGET_NUCLEO_F072RB) || defined(TARGET_NUCLEO_F091RC) || defined(TARGET_NUCLEO_F207ZG) || defined(TARGET_NUCLEO_F302R8) || defined(TARGET_NUCLEO_F303K8) || defined(TARGET_DISCO_F303VC) || defined(TARGET_NUCLEO_F303RE) || defined(TARGET_NUCLEO_F303ZE) || defined(TARGET_DISCO_F334C8) || defined(TARGET_NUCLEO_F334R8) || defined(TARGET_MTS_DRAGONFLY_F411RE) || defined(TARGET_MTS_MDOT_F405RG) || defined(TARGET_MTS_MDOT_F411RE) || defined(TARGET_DISCO_F401VC) || defined(TARGET_NUCLEO_F401RE) || defined(TARGET_ARCH_MAX) || defined(TARGET_DISCO_F407VG) || defined(TARGET_NUCLEO_F410RB) || defined(TARGET_ELMO_F411RE) || defined(TARGET_NUCLEO_F411RE) || defined(TARGET_NUCLEO_F412ZG) || defined(TARGET_DISCO_F413ZH) || defined(TARGET_DISCO_F429ZI) || defined(TARGET_NUCLEO_F429ZI) || defined(TARGET_NUCLEO_F439ZI) || defined(TARGET_B96B_F446VE) || defined(TARGET_NUCLEO_F446RE) || defined(TARGET_NUCLEO_F446ZE) || defined(TARGET_DISCO_F469NI) || defined(TARGET_DISCO_F746NG) || defined(TARGET_NUCLEO_F746ZG) || defined(TARGET_NUCLEO_F756ZG) || defined(TARGET_NUCLEO_F767ZI) || defined(TARGET_DISCO_F769NI) || defined(TARGET_DISCO_L072CZ_LRWAN1) || defined(TARGET_NUCLEO_L432KC) || defined(TARGET_DISCO_L476VG) || defined(TARGET_NUCLEO_L476RG) || defined(TARGET_NUCLEO_L486RG)
AnalogIn adc_vbat(ADC_VBAT); // Warning: Not available on all devices
#endif

// my vars
const int DimX=BSP_LCD_GetXSize()-1;
const int DimY=BSP_LCD_GetYSize()-1;
#define MAXMENU 3
int nummenu=0;
char str[128];
#define IP         "192.168.1.177"
#define GATEWAY    "192.168.1.1"
#define MASK       "255.255.255.0"
#define PORTA       29999


// Network interface
//se li metto qui non sgancia ma blocca ciclo
TCPSocket client;
SocketAddress client_addr;
//


//external
DigitalOut led1(LED1);
InterruptIn button(USER_BUTTON);

// Setting of button group
Button avanti(BSP_LCD_, ts_, DimX-37, 50, 38, 170, LCD_COLOR_BLUE, LCD_COLOR_BLACK, ">>", Font12);
Button indietro(BSP_LCD_, ts_, 0, 50, 38, 170, LCD_COLOR_BLUE, LCD_COLOR_BLACK, "<<", Font12);


//Touch
# define NUMLAYER 2
TS_StateTypeDef TS_State;
uint8_t status;

#include "Functions.h"
#include "ProgFunctions.h"

int main()
{
    //Tasto
    button.rise(&PressButton);
    //timer
    StartArduinoTimer();
    //Ticker
    GestioneOutput.attach(&UsciteVideo,0.1);

    // DISPLAY
    BSP_LCD_Init();
    BSP_LCD_DisplayOn();
    /* Initialize the LCD Layers */
    BSP_LCD_LayerRgb565Init(0, LCD_FB_START_ADDRESS);
    BSP_LCD_LayerRgb565Init(1, LCD_FB_START_ADDRESS+(BSP_LCD_GetXSize()*BSP_LCD_GetYSize()*NUMLAYER)); //Reserve memory art SRAM acc. resolution and color format

    for (int idx = 0; idx < NUMLAYER; idx++) {
        BSP_LCD_SetTransparency (idx, 255);
        SetLayer( idx);
        //  BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
        //  BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);
        BSP_LCD_Clear(LCD_COLOR_BLACK);
        BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
    }
    SetLayer( 0);

    //frames
    BSP_LCD_SetTextColor(LCD_COLOR_YELLOW);
    BSP_LCD_DrawRect(0, 0, DimX/3, 40);
    BSP_LCD_DrawRect(DimX/3+5, 0, ((DimX*2)/3)-5, 40);
    BSP_LCD_DrawRect(40, 45, DimX-80, DimY-45-45);
    BSP_LCD_DrawRect(0, DimY-40, DimX, 40);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_.SetFont(&Font12);
    BSP_LCD_DisplayStringAt(5, 3, (uint8_t *)"Test All 0.2 ", LEFT_MODE);
    BSP_LCD_DisplayStringAt(5, 23, (uint8_t *)"Max Scordamaglia 2020", LEFT_MODE);
    BSP_LCD_.SetFont(&Font24);
    BSP_LCD_SetTextColor(LCD_COLOR_YELLOW);
    BSP_LCD_DisplayStringAt(DimX/3+10, 10, (uint8_t *) "Dati Generali", LEFT_MODE);

    // touch
    status = BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize());
    BSP_LCD_.SetFont(&Font12);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    if (status != TS_OK) {
        BSP_LCD_DisplayStringAt(300, LINE(4), (uint8_t *)"TOUCHSCREEN INIT FAIL", LEFT_MODE);
    } else {
        BSP_LCD_DisplayStringAt(300, LINE(4), (uint8_t *)"TOUCHSCREEN INIT OK", LEFT_MODE);
    }
    Button::SetMultiTouch(false);

    // Buttons
    avanti.Draw(LCD_COLOR_BLUE, LCD_COLOR_YELLOW);
    indietro.Draw(LCD_COLOR_BLUE, LCD_COLOR_YELLOW);
    //    multiTouch.Draw(0, LCD_COLOR_DARKBLUE);

    // ethernet interface
    EthernetInterface eth;
    eth.set_network("192.168.1.177","255.255.255.0","192.168.1.1");
    eth.connect();

    //Server
    TCPServer srv(&eth);
    srv.set_blocking(false);
    srv.bind(29999);
    srv.listen();

    if (nummenu==0) {
        sprintf(str,"The Server IP address is '%s', port %d", eth.get_ip_address(), PORTA);
        BSP_LCD_.SetFont(&Font12);
        BSP_LCD_SetTextColor(LCD_COLOR_MAGENTA);
        BSP_LCD_DisplayStringAt(0, LINE(14), (uint8_t *) str, CENTER_MODE);
    }


    while(1) {
        FattorizzazioneCiclica(); //1
        RoutineCiclicaSocket(srv);
    }
}



