#ifndef PROGRAMFUNCTIONS_H
#define PROGRAMFUNCTIONS_H
using namespace ButGrp;

void SetLayer(int numlayer, int tipo=0)
{
    return;
    // vedere come passare BSPLCD_
    for (int idx = 0; idx < NUMLAYER; idx++) {
        //  sprintf(str, "Touches: %d",idx);
        BSP_LCD_DisplayStringAt(0, LINE(12+idx), (uint8_t *)&str, LEFT_MODE);
        if (idx==numlayer) {
            BSP_LCD_SetLayerVisible(idx, ENABLE);
            BSP_LCD_SelectLayer(idx);
            //   BSP_LCD_DisplayStringAt(50, LINE(12+idx), (uint8_t *)"ON", RIGHT_MODE);
        } else  {
            if (tipo==0) {
                BSP_LCD_SetLayerVisible(idx, DISABLE);
                // BSP_LCD_DisplayStringAt(50, LINE(12+idx), (uint8_t *)"OFF", RIGHT_MODE);
            }
        }
    }
}

void PressButton()
{
    static int ccont=0;
    led1= !led1;
    ccont++;
    if (nummenu==0) {
        BSP_LCD_.SetFont(&Font16);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        sprintf(str, "Tasto premuto %d volte", ccont);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *) str, CENTER_MODE);
    }
}

void ReadSensors()
{
    static long long int conteggio=0;
    if (conteggio+1000<millis()) {
        BSP_LCD_.SetFont(&Font16);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        sprintf(str,"ADC Temp = %6.4f", adc_temp.read()*100);
        BSP_LCD_DisplayStringAt(140, LINE(7), (uint8_t *) str, LEFT_MODE);
        sprintf(str,"ADC VRef =  %6.4f", adc_vref.read());
        BSP_LCD_DisplayStringAt(140, LINE(8), (uint8_t *) str, LEFT_MODE);
#if defined(TARGET_DISCO_F051R8) || defined(TARGET_NUCLEO_F030R8) || defined(TARGET_NUCLEO_F031K6) || defined(TARGET_NUCLEO_F042K6) || defined(TARGET_NUCLEO_F070RB) || defined(TARGET_NUCLEO_F072RB) || defined(TARGET_NUCLEO_F091RC) || defined(TARGET_NUCLEO_F207ZG) || defined(TARGET_NUCLEO_F302R8) || defined(TARGET_NUCLEO_F303K8) || defined(TARGET_DISCO_F303VC) || defined(TARGET_NUCLEO_F303RE) || defined(TARGET_NUCLEO_F303ZE) || defined(TARGET_DISCO_F334C8) || defined(TARGET_NUCLEO_F334R8) || defined(TARGET_MTS_DRAGONFLY_F411RE) || defined(TARGET_MTS_MDOT_F405RG) || defined(TARGET_MTS_MDOT_F411RE) || defined(TARGET_DISCO_F401VC) || defined(TARGET_NUCLEO_F401RE) || defined(TARGET_ARCH_MAX) || defined(TARGET_DISCO_F407VG) || defined(TARGET_NUCLEO_F410RB) || defined(TARGET_ELMO_F411RE) || defined(TARGET_NUCLEO_F411RE) || defined(TARGET_NUCLEO_F412ZG) || defined(TARGET_DISCO_F413ZH) || defined(TARGET_DISCO_F429ZI) || defined(TARGET_NUCLEO_F429ZI) || defined(TARGET_NUCLEO_F439ZI) || defined(TARGET_B96B_F446VE) || defined(TARGET_NUCLEO_F446RE) || defined(TARGET_NUCLEO_F446ZE) || defined(TARGET_DISCO_F469NI) || defined(TARGET_DISCO_F746NG) || defined(TARGET_NUCLEO_F746ZG) || defined(TARGET_NUCLEO_F756ZG) || defined(TARGET_NUCLEO_F767ZI) || defined(TARGET_DISCO_F769NI) || defined(TARGET_DISCO_L072CZ_LRWAN1) || defined(TARGET_NUCLEO_L432KC) || defined(TARGET_DISCO_L476VG) || defined(TARGET_NUCLEO_L476RG) || defined(TARGET_NUCLEO_L486RG)
        sprintf(str,"ADC VBat =  %6.4f", adc_vbat.read());
        BSP_LCD_DisplayStringAt(140, LINE(9), (uint8_t *) str, LEFT_MODE);
#endif
        conteggio=millis();
    }

}

void GestioneButton()
{
    // vedi buttoGroup_Demo per esempio group
    static bool toccato=false;
    bool modifica=false;
    BSP_TS_GetState(&TS_State);


    if ((avanti.Touched())&& (toccato==false)) {
        nummenu=(++nummenu)%MAXMENU;
        // reset.Draw(INACTIVE, LCD_COLOR_GRAY);
        modifica=true;
    }
    if ((indietro.Touched()) && (toccato==false)) {
        nummenu=((--nummenu)+MAXMENU)%MAXMENU;
        // reset.Draw(INACTIVE, LCD_COLOR_GRAY);
        modifica=true;
    }
    wait(0.01f);

    if((TS_State.touchDetected) && (toccato==false)) {
        toccato=true;
    } else if((!TS_State.touchDetected) && (toccato==true)) {
        toccato=false;
    }

    if (modifica==true) {
        if (nummenu==0) {
            BSP_LCD_.SetFont(&Font12);
            BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
            sprintf(str, "menu: %d", nummenu);
        }
        BSP_LCD_DisplayStringAt(50, LINE(7), (uint8_t *)str, LEFT_MODE);
        BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
        BSP_LCD_FillRect(40+1, 45+1, DimX-80-1, DimY-45-45-1); //cancella corpo
        BSP_LCD_FillRect(DimX/3+6, 1, ((DimX*2)/3)-7, 38); //cancella titolo
        BSP_LCD_.SetFont(&Font24);
        BSP_LCD_SetTextColor(LCD_COLOR_YELLOW);
        switch (nummenu) {
            case 0:
                BSP_LCD_DisplayStringAt(DimX/3+10, 10, (uint8_t *) "Dati Generali", LEFT_MODE);
                break;
            case 1:
                BSP_LCD_DisplayStringAt(DimX/3+10, 10, (uint8_t *) "Math elaborations", LEFT_MODE);
                break;
            case 2:
                BSP_LCD_DisplayStringAt(DimX/3+10, 10, (uint8_t *) "Dati TCP", LEFT_MODE);
                break;
        }
    }
}

void GestioneTouch()
{
    static uint16_t x=0, y=0;
    uint8_t cleared = 0;
    uint8_t prev_nb_touches = 0;
    BSP_TS_GetState(&TS_State);
    BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_.SetFont(&Font16);
    if (TS_State.touchDetected) {
        // Clear lines corresponding to old touches coordinates
        if (TS_State.touchDetected < prev_nb_touches) {
            for (int idx = (TS_State.touchDetected + 1); idx <= 5; idx++) {
                BSP_LCD_ClearStringLine(idx);
            }
        }
        prev_nb_touches = TS_State.touchDetected;
        cleared = 0;
        sprintf(str, "Touches: %d", TS_State.touchDetected);
        BSP_LCD_DisplayStringAt(50, LINE(3), (uint8_t *)str, LEFT_MODE);
        SetLayer( 1);
        BSP_LCD_DrawPixel(x, y, LCD_COLOR_BLACK);
        SetLayer( 0);
        for (int idx = 0; idx < TS_State.touchDetected; idx++) {
            x = TS_State.touchX[idx];
            y = TS_State.touchY[idx];
            sprintf(str, "Touch %d: x=%d y=%d    ", idx+1, x, y);
            BSP_LCD_DisplayStringAt(50, LINE(idx+4), (uint8_t *)str, LEFT_MODE);
        }
        SetLayer( 1);
        BSP_LCD_DrawPixel(TS_State.touchX[0], TS_State.touchY[0], LCD_COLOR_WHITE);
        SetLayer( 0);
    } else {
        if (!cleared) {
            sprintf(str, "Touches: 0");
            BSP_LCD_DisplayStringAt(50, LINE(3), (uint8_t *)&str, LEFT_MODE);
            cleared = 1;
        }
    }
}

void PrintData(char sstr[],SocketAddress &clientaddr)
{
    if ((nummenu==2) && (sstr[0]>0)) {
        BSP_LCD_.SetFont(&Font12);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(55, LINE(6), (uint8_t *) sstr, LEFT_MODE);
        const char *ip = clientaddr.get_ip_address();
        int port = clientaddr.get_port();
        sprintf(str,"IP Client: %s", ip);
        BSP_LCD_DisplayStringAt(55, LINE(10), (uint8_t *) str, LEFT_MODE);
        sprintf(str,"Port: %d", port);
        BSP_LCD_DisplayStringAt(55, LINE(11), (uint8_t *) str, LEFT_MODE);
    }
}


void ReceiveData(TCPSocket &clnt)
{
    char mmm[64];
    memset (str,0,128);
    clnt.recv(str, sizeof str);
    if (((nummenu==0)||(nummenu==2)) &&(str[0]>0)) {
        sprintf(mmm,"Receive: %d", millis());
        BSP_LCD_.SetFont(&Font12);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(150, LINE(17), (uint8_t *) mmm, LEFT_MODE);
    }
}

void RoutineCiclicaSocket(TCPServer &srvR)
{
    // se li lascio qui non bloccano ma sganciano
    //  TCPSocket client; //lui
    // SocketAddress client_addr;
    // srvR.set_blocking(false);
    srvR.accept(&client, &client_addr); //  BLOCCANTE senza  srv.set_blocking(false);

    if ((nummenu==0)||(nummenu==2))  {
        sprintf(str,"Accept: %d", millis());
        BSP_LCD_.SetFont(&Font12);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(50, LINE(17), (uint8_t *) str, LEFT_MODE);
    }

    ReceiveData(client);  //2
    PrintData(str,client_addr );
    //  client.close();

}

void UsciteVideo()
{
    char mmm[64];

    GestioneButton(); //sempre
    if (nummenu==0) {
        GestioneTouch();
        ReadSensors();
    }
   // FattorizzazioneCiclica(); //1

        sprintf(mmm,"Tick: %d", millis());
        BSP_LCD_.SetFont(&Font12);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(350, LINE(17), (uint8_t *) mmm, LEFT_MODE);
   

}


#endif