#include "mbed.h"
#include "EFM32_SegmentLCD.h"
#include "IOFuncLib.h"


silabs::EFM32_SegmentLCD segmentDisplay;


/*------------ Constant definitions --------------*/
#define TX_PIN          USBTX
#define RX_PIN          USBRX
#define BRATE           9600
#define LED_PIN         LED1
#define TOGGLE_RATE     (1.0f)
#define BUFF_LENGTH     7

#define INIT_SECONDS        0

/*-------- Check if platform compatible ----------*/
#if DEVICE_SERIAL_ASYNCH
Serial test_connection(USBTX, USBRX);
#else
#error "Platform not compatible with Low Power APIs for Serial"
#endif

/*------------------ Variables -------------------*/
LowPowerTicker      blinker;
bool                blinking = false;
event_callback_t    serialEventCb;
//DigitalOut          LED(LED_PIN);
uint8_t             rx_buf[BUFF_LENGTH + 1];

volatile uint32_t seconds = INIT_SECONDS;
Flasher led(LED_PIN);

/******************** Define Timers *****************************/
// devo separare i timers. Non so il perche'
LowPowerTicker refreshTicker;
/*------------------ Callbacks -------------------*/


//------------ Funzioni -------------
#include "Functions.h"

//-------------------------------------


/*-------------------- Main ----------------------*/
int main()
{
    /* Very Simple Main (tm) */
    serialEventCb.attach(serialCb);

    /* Setup serial connection */
    test_connection.baud(BRATE);
    test_connection.printf("Low Power API test\n\nSend 'X' to toggle blinking\n");
    test_connection.read(rx_buf, BUFF_LENGTH, serialEventCb, SERIAL_EVENT_RX_ALL, 'X');

    /* Let the callbacks take care of everything */
    refreshTicker.attach(&tickerCallback, 1.0f);

    while(1) sleep();
}