#include <string>
genFunctions fnz;


/*
 * Callback for 1 second timebase
 */
void tickerCallback(void)
{
    seconds++;
    uint32_t clockValue = ((seconds / 60) % 60) * 100 + (seconds % 60);
    segmentDisplay.Number(clockValue);
    segmentDisplay.Symbol(LCD_SYMBOL_COL10, seconds & 0x1);
}

void blink(void)
{
    //sarebbe bene evitare questa funzione ma il notPin non funziona direttamente dentro blinker.attach(blink, TOGGLE_RATE);
    led.notPin();
}


void serialCb(int events)
{
    /* Something triggered the callback, either buffer is full or '\n' is received */
    unsigned char i;
    string stringout;

    if(events & SERIAL_EVENT_RX_CHARACTER_MATCH) {
        //Received 'S', check for buffer length
        for(i = 0; i < BUFF_LENGTH; i++) {
            //Found the length!
            stringout=stringout+fnz.char2string(rx_buf[i]);
            if ((rx_buf[i] == '\n') || (rx_buf[i] == 'X')) break;
        }

        // Toggle blinking
        if(blinking) {
            blinker.detach();
            blinking = false;
        } else {
            blinker.attach(blink, TOGGLE_RATE);
            blinking = true;
        }
    } else if (events & SERIAL_EVENT_RX_COMPLETE) {
        i = BUFF_LENGTH - 1;
    } else {
        rx_buf[0] = 'E';
        rx_buf[1] = 'R';
        rx_buf[2] = 'R';
        rx_buf[3] = '!';
        rx_buf[4] = 0;
        i = 3;
    }

    segmentDisplay.Write((char *)rx_buf);
    //oppure
    // segmentDisplay.Write((char *) stringout.c_str());

    // Echo string, no callback
    test_connection.write(rx_buf, i+1, 0, 0);


    // Reset serial reception
    test_connection.read(rx_buf, BUFF_LENGTH, serialEventCb, SERIAL_EVENT_RX_ALL, 'X');
}

void tickerCallback(void);