/** **************************************
In un tempo variabile tra 1 e 5 secondi, refreshticker cambia scritta e nel contempo cambia:
- temporizzazione di led0: meta' tempo acceso l'altra meta' spento
- temporizzazione di led1: meta' tempo lampeggia, l'altra meta' (controllata dal'evento led0) resta acceso
- accende io jecko che viene spento da led0
I tasti rispondono, il sensore pure


*/

#include "EFM32_SegmentLCD.h"
#include "EFM32_CapSenseSlider.h"

/******************** Define I/O *****************************/
InterruptIn in0(PB9);
InterruptIn in1(PB10);

silabs::EFM32_SegmentLCD segmentDisplay;
silabs::EFM32_CapSenseSlider capSlider;

DigitalOut myled1(LED1);
DigitalOut myled0(LED0);

Serial pc(USBTX, USBRX); //Apertura della seriale 2

/******************** Define Timers *****************************/
// devo separare i timers. Non so il perche'
LowPowerTicker refreshTicker;
LowPowerTicker ledTicker0;
LowPowerTicker ledTicker1;
LowPowerTicker timeTicker;

/***************** Define global variables **********************/
#define INIT_SECONDS		0
#define TEST_DURATION		10

volatile uint32_t seconds = INIT_SECONDS;
int count = -1;


/***************** Define callback handlers *********************/
void tickerCallback(void);
void in0_handler();
void in1_handler();
void touchCallback(void);
void slideCallback(void);

//------------ Funzioni -------------

#include "Functions.h"


/*************************** MAIN *******************************/
int main()
{
    // Initialize pushbutton handler
    in0.rise(NULL);
    in0.fall(in0_handler);

    in1.rise(NULL);
    in1.fall(in1_handler);

    // Enable the capacitive slider
    capSlider.start();
    capSlider.attach_touch(touchCallback);
    capSlider.attach_untouch(touchCallback);
    capSlider.attach_slide(-1, slideCallback);

    // Start generating the 1Hz timebase
    refreshTicker.attach(&tickerCallback, 1.0f);
    timeTicker.attach(&timeDisp, 1.0f);
    ledTicker0.attach(&ledTogglerGen, 0.5f);
        ledTicker1.attach(&ledToggler, 0.1f);

    printf("Initialization done! \n\r");
    wait(0.01f); //Need to delay slightly to give the serial transmission a chance to flush out its buffer

    //inizializza random
    srand (time(NULL));

    // Go into sleeping mode
    while(1) {
        sleep();
    }
}

