#include <stdlib.h>
//#include <pthread.h>
//#include <semaphore.h>
#include "mbed.h"
//#include "string.h"
#include <stdio.h>
#include <ctype.h>
#include "x_nucleo_iks01a1.h"
#include "rtos.h"
 
#define RAND_DIVISOR 100000000
#define TRUE 1
 
 
 void consumer(void const *arg);
 
void thread1(void *param);

//Thread* printSampleThread = new Thread(printCurrentRecord);
 
//setting out variables
 
/**
/ this is setting up the connection from the board
**/ 
 
static X_NUCLEO_IKS01A1 *mems_expansion_board = X_NUCLEO_IKS01A1::Instance(D14, D15);
static HumiditySensor *humidity_sensor = mems_expansion_board->ht_sensor;
static PressureSensor *pressure_sensor = mems_expansion_board->pt_sensor;
static TempSensor *temp_sensor1 = mems_expansion_board->ht_sensor;
//static TempSensor *temp_sensor2 = mems_expansion_board->pt_sensor;
 
/*
/ this is will make sure the contant valid of how much data will be sorted or not as this
/could help when the data range.
*/
const int AMOUNT_OF_SAMPLE = 150;
 
const int BUFFER_SIZE = 75;

int secondsOfsample = 0;

/*
this is storing the current array of the sample
*/
char outputSample[200]; 
 
// Mutex lock
Mutex *bufferLock = new Mutex;
 
//buffer
char buffer_item[BUFFER_SIZE];
 
 
 
Thread *tid; //thread id
//pthread_attr_t attr; //set of thread attributes
 
void *producer(void *param); //producer thread
void *consumer(void *param); //consumer thread
 
 
 
volatile char memorySample[AMOUNT_OF_SAMPLE];
 
char values[20][20];
 
 
 
 
uint8_t id;
 
 
//class
 
class KeyLocks {
    
    public:
        int key;
        
        KeyLocks(){
            
            key = 0;
            
        }
        
        bool unlock(void)
        {
             if(key == 0){
                 
                 key = 1;
                 return true;
                 
            }else{
                return false;
                
                }
        } 
        
        bool lock(void)
        {
             if(key == 1){
                 
                 key = 0;
                 return true;
                 
            }else{
                return false;
                
                }
        } 
            
};
 
class SampleRate : public KeyLocks 
{
    public:
        /*
        /this is going the amount of time which the data sample will be taking and this will have
        /a default stating of every 15 second but can be changed
        */
        int sampleRate;
        
        SampleRate(){
            
            sampleRate = 15;
            
        }
        
        int getSampleRate(void)
        {
             return sampleRate;
        } 
        void setSampleRate(double newSampleRate){
            
            sampleRate = newSampleRate;
            
        }
        
        
        
};
 
 
class TakeSample : public KeyLocks
{
    public:
        /*
        /this is going to take the sample or not as this can change if the person thing it could happen 
        /which will see if the data is stored   
        */  
        bool takeSample;
        
        TakeSample(){
            takeSample = true;    
        }
        
        int getTakeSample(void)
        {
             return takeSample;
        } 
        void setTakeSample(bool newTakeSample){
            
            takeSample = newTakeSample;
            
        }       
};
 
 
 
class SampleTemp: public KeyLocks
{
    public: 
    
        SampleTemp(){}
        float currentTemp;       
        /*
        /this is the fuction which will get the humidity for the external devices
        */
        float getTemp(void) 
        {
            temp_sensor1->GetTemperature(&currentTemp); 
            return currentTemp;  
        }              
};
 
class SampleHumitaty: public KeyLocks
{
    public: 
    
        SampleHumitaty(){}
    
        float currentHumitaty;        
        /*
        /this is the fuction which will get the humidity for the external devices
        */
        float getHumidity() 
        {
            humidity_sensor->GetHumidity(&currentHumitaty);
            return currentHumitaty;
            
        }              
};
 
 
class SamplePressure: public KeyLocks 
 
{
    public:
    
        SamplePressure(){}   
    
        float currentPressure;     
        /*
        /this is the fuction which will get the pressure for the external devices
        */
        float getPressure() 
        {
            pressure_sensor->GetPressure(&currentPressure);
            return currentPressure;
        }             
};
 
class SampleDisplay: public KeyLocks
{
    public:
        /*
        /this is the variable to see if the data will be display or not after the data being sorted
        /this can change by the user input
        */
 
        bool display;
        
        SampleDisplay(){
            display = false;
        }
        
        bool getTakeDisplay(void)
        {
             return display;
        } 
        void setDisplay(bool newSampleDisplay){
            
            display = newSampleDisplay;
            
        }       
};
 
 
 
 
class BufferStartPointer: public KeyLocks
{
    public:
        /*
        /this is the pointer to start of the buffer as this will make the buffer be cycler
        */
        int bufferStartPointer;
        int bufferSize;
        
        BufferStartPointer(int newBufferSize){
            bufferStartPointer = 0;
            bufferSize = newBufferSize;
        }
        
        int getBufferStartPointer (void)
        {
             key = 1;
             return bufferStartPointer;
             
        } 
        void setBufferStartPointer (int newBufferStartPointer ){
            
            bufferStartPointer = newBufferStartPointer;
            
        } 
        void plusOne(void){ 
            if(bufferStartPointer + 1 == bufferSize){
                bufferStartPointer = 0;
            }else{
                bufferStartPointer = bufferStartPointer + 1;
                }
        }    
};
 
 
class BufferEndPointer: public KeyLocks
{
    public:
        /*
        /this is the pointer to End of the buffer as this will make the buffer be cycler
        */
        int bufferEndPointer;
        
        int bufferSize;
        
        BufferEndPointer(int newBufferSize){
            bufferEndPointer = 0;
            bufferSize = newBufferSize;
        }
        
        
        BufferEndPointer(){
            bufferEndPointer = 0;
        }
        
        int getBufferEndPointer (void)
        {
             return bufferEndPointer;
        } 
        void setBufferEndPointer (int newBufferEndPointer ){
            
            bufferEndPointer = newBufferEndPointer;
            
        } 
        
          void plusOne(void){ 
            if(bufferEndPointer + 1 == bufferSize){
                bufferEndPointer = 0;
            }else{
                bufferEndPointer = bufferEndPointer + 1;
                }
        }        
};
 
class BufferSize: public KeyLocks
{
    
    public:
            int bufferSize;
            Semaphore *EmptyBuffer;
            Semaphore *fullBuffer;
            
            BufferSize(){
                EmptyBuffer = new Semaphore(0);
                fullBuffer = new Semaphore(BUFFER_SIZE);
                bufferSize = 0;
                
            }
            
            void increaseBufferSize(){
                bufferSize = bufferSize + 1;
            }
            
            void deincreaseBufferSize(){
                bufferSize = bufferSize - 1;
            }
            
            int getBufferSize(){
                return bufferSize;
            }
            
            int getEmptyBuffer(){
                return EmptyBuffer -> wait();
            }
            
            int getFullBuffer(){
                return fullBuffer -> wait();
            }
            
            void releaseEmptyBuffer(){
                EmptyBuffer -> release();
            }
            
            void releaseFullBuffer(){
                fullBuffer -> release();
            }
    
    
};


class SampleString: public KeyLocks
{
    public:
            char word[100];
            
            SampleString(){}
            
            char*  getWord(){
                return word;
            }
            
            void setWord(char* newWord){
                
                //word = newWord;
                
            }
    
};


SampleTemp sampleTemp = SampleTemp();
SampleHumitaty sampleHumitaty = SampleHumitaty();
SamplePressure samplePressure =  SamplePressure();
SampleString samplString = SampleString();

SampleRate sampleRate =  SampleRate();
TakeSample takeSample = TakeSample();
SampleDisplay sampleDisplay = SampleDisplay();

BufferStartPointer bufferStartPointer = BufferStartPointer(BUFFER_SIZE);
BufferEndPointer ramEndPointer = BufferEndPointer(AMOUNT_OF_SAMPLE);
BufferEndPointer bufferEndPointer = BufferEndPointer(BUFFER_SIZE);
BufferSize bufferSize = BufferSize();
 
/**void initialiseBufferData(){
    //create mutex lock
    pthread_mutex_init(&mutex, NULL);
    
    //create full semaphore and initialise to 0
    sem_init(&full, 0, 0);
    
    //create empty semaphore and initialise to BUFFER_SIZE
    sem_init(&empty, 0, BUFFER_SIZE);
    
    //get default attributes
    pthread_attr_init(&attr);
    
    //init buffer
    counter = 0;
}**/
 
 
  
/*
/read Record is the selected data which be passed in as a a string
*/
void printCurrentString(char* displayString, int length) 
{        
    printf("%s\n", displayString);
    
    
}

/*
/read Record is the selected data which be passed in as a a string
*/
void printCurrentRecord(void const *arg) 
{    
    //strftime(buf, sizeof(buf), "%Y-%m-%d.%X", &time);
    printf("\n%s\n", outputSample);
    
    
}
//producer thread
void producer(void const *arg){
   
   while(!bufferSize.lock()){};
   
   int size = bufferSize.getBufferSize();
   
   if(size < BUFFER_SIZE){
       //sleep for random amount of time
       
       //get the buffer
       bufferLock->lock(); 
 
           
        while(!bufferEndPointer.lock()){};       
        bufferEndPointer.plusOne();
        const int bufferIndex = bufferEndPointer.getBufferEndPointer();
        bufferEndPointer.unlock();
        
        //while(!samplString.lock()){};   
        buffer_item[bufferIndex] = *outputSample;   
        //samplString.unlock();    
        bufferLock->unlock();
        
        while(!bufferSize.lock()){};
        bufferSize.increaseBufferSize();
        bufferSize.unlock();             
        
    }
    //Thread consumerTread(consumer);
    
    //Thread::terminate;
}
 
//consumer thread
void consumer(void const *arg){
   
   while(!bufferSize.lock()){};
   
   int size = bufferSize.getBufferSize();
   
   while(size > 0){
       //sleep for random amount of time
       
       //get the buffer
       bufferLock->lock(); 
        
        while(!ramEndPointer.lock()){};
        
        int ramIndex = ramEndPointer.getBufferEndPointer();
        
        ramEndPointer.unlock();
           
        while(!bufferStartPointer.lock()){};
       
        bufferStartPointer.plusOne();
    
            
        memorySample[ramIndex] = buffer_item[bufferStartPointer.getBufferStartPointer()];
            
        
        
        bufferStartPointer.unlock();
        bufferLock->unlock();
        
        
        while(!bufferSize.lock()){};
        bufferSize.deincreaseBufferSize();
        size = bufferSize.getBufferSize();       
           
        
    }  
}



static char *printDouble(char* str, double v, int decimalDigits=2)
{
    int i = 1;
    int intPart, fractPart;
    int len;
    char *ptr;
 
    /* prepare decimal digits multiplicator */
    for (;decimalDigits!=0; i*=10, decimalDigits--);
 
    /* calculate integer & fractinal parts */
    intPart = (int)v;
    fractPart = (int)((v-(double)(int)v)*i);
 
    /* fill in integer part */
    sprintf(str, "%i.", intPart);
 
    /* prepare fill in of fractional part */
    len = strlen(str);
    ptr = &str[len];
 
    /* fill in leading fractional zeros */
    for (i/=10;i>1; i/=10, ptr++) {
        if(fractPart >= i) break;
        *ptr = '0';
    }
 
    /* fill in (rest of) fractional part */
    sprintf(ptr, "%i", fractPart);
 
    return str;
}
 
/*
/this is going to sort the string to see the opertion which will picked the opertion which 
/need the be carried out and the put the data in to the tread to then which the tread will
/do it operation
*/
void sortString(char*  inputString) 
{
     
     //if("DELETE" == values[0]){         
         
         //printCurrentRecord(values[]);
         
     //}
     
    //https://developer.mbed.org/teams/Students-Plymouth-University-UK-SoCEM/
    
}
 
 
 
 
/*
/this is function that will written to the memory of the from the buffer so that will be fast
/ and did not lose anydata
*/
void writtenToMemory(const void* arg ) 
{
    
}
 
 
//this is setting all the function for the treads in the program
 
 
 

 
/*
/this is fucntion which the important the updateSample rate 
*/
void updateSample(void const *arg) 
{
     bool continueSampling;

    do{
        while(samplePressure.lock()){};
        float currentPressure = samplePressure.getPressure();
        samplePressure.unlock();
        
        char samplePress[10];
        printDouble(samplePress, currentPressure, 2);      
        
    
        while(sampleHumitaty.lock()){};
        
        float current= sampleHumitaty.getHumidity();
        sampleHumitaty.unlock();    
      
        char sampleHum[10];
        printDouble(sampleHum, current, 2);
    
        while(sampleTemp.lock()){};
        
        float currentTemp= sampleTemp.getTemp();
        sampleTemp.unlock();
        
        char sampleTemp[10];
        printDouble(sampleTemp, currentTemp, 2);
        
        //time_t  currentTime;
        //time(&currentTime);
        //struct tm tstruct = *localtime(&currentTime);
        
        
        while(takeSample.lock()){};
        
        continueSampling = takeSample.getTakeSample();
        takeSample.unlock();
        
        int amountOfsec = sampleRate.getSampleRate();
        
        sprintf(outputSample, "Pressure : %s, Temp : %s, Hum : %s Time: %d seconds", samplePress, sampleTemp, sampleHum,  secondsOfsample);
        
        Thread sampleDisplayTread(printCurrentRecord);
        Thread producerTread(producer);
        
        secondsOfsample = secondsOfsample + amountOfsec;
        
        
        Thread::wait(amountOfsec*1000);
        
        
        
    }while (continueSampling);
    
        
    
    
   
    
}
 
 
void splitString(char inputString[]){
       int sizeOfArray = 1000;
       char opertaion[sizeOfArray];
       char data[sizeOfArray];
       
       for (int i = 0; i < 20; i++){
           for (int j = 0; i < 20; j++){
               values[i][j] =' ';
               
            }
        }
        
       for (int i = 0; i < sizeOfArray; i++){
         
            if(inputString[i] == '<'){
                for(int j=0; j < i; j++){
                   
                   opertaion[j] = inputString[j];                  
                   
                }
                
                int index = 0;
                
                for(int k=i+1; k < sizeOfArray - 1; k++){
                    
                    data[index] = (inputString[k]);
                    index++;
                    
                } 
                
                
                
                for(int y = 0; y < 20; y++){
                  values[0][y] = opertaion[y];
                }
                
                for(int z = 0;z < 20; z++){
                    values[1][z] = data[z];
                }
                         
                break;
                   
            } 
        }
}
 

 
/*
/this is he deleteRecords which will move the buffer regard so that the bufferent will over 
/write to the  old data in the fifo buffer
*/
void deleteRecord(const void* arg ) 
{
    
}
 
 
/*
/read Record is the most reason data which which is store in the data 
*/
void readRecord(const void* arg ) 
{
    
}
 

 
void deleteAll(BufferStartPointer* bufferStart, BufferEndPointer* bufferEnd){
 
    while(bufferStart -> lock()){}
    bufferStart -> setBufferStartPointer(0);
    bufferStart -> unlock();
    
    while(bufferEnd -> lock()){};
    bufferEnd -> setBufferEndPointer(0);
    bufferEnd -> unlock();
    
    
    // need the ram memory
    
    
 
 
    
}
 
/*
/this is the fuction which update the the sample rate so the int to
/update  the value whoch might hange
*/
void updateSampleRate(double newSampleRate, SampleRate* sampleRate) 
{
    while(!sampleRate -> lock()){};
    char outputString = 'OUT OF RANGE';
    
    if(newSampleRate >= 0.1 && newSampleRate <= 60.0){
         sampleRate -> setSampleRate(newSampleRate); 
         char decimel;
         printDouble(&decimel, newSampleRate, 2);
          
         outputString = 'UPDATE<' + decimel + '>'; 
    }   
    sampleRate -> unlock();
    
}
 
/*/
/this is update the the log so see if the log if the the sample rate 
ozr not
*/
void updateLog(char logType, TakeSample *takeSample) 
{
    char output = ' ';
    
    while(takeSample -> lock()){};
    
    
    if(logType == 'NO'){
        takeSample -> setTakeSample(false);
         output ='Log<ON>';
        
            
    }
    
    if(logType == 'YES' ){
        takeSample -> setTakeSample(true);
        output ='Log<OFF>';
                        
        
    }
    takeSample -> unlock();
    
    //need output tread
    
}
 
/*
/tthis is update th date which the system will go from and with change
/  the date so that the records are set with the date.
*/
void updateDate(char newDate[]) 
{
    
}
 
/*
/tthis is update th time which the system will go from and with change
/  the time so that the records are set with the date.
*/
void updateTime(char newTime[]) 
{
    
}
 
void updateDisplayState(SampleDisplay* sampleDisplay, char displayString){
    
    char output = ' ';
    
    while(!sampleDisplay -> lock()){};
    if(displayString == 'NO'){
        sampleDisplay -> setDisplay(false);
        output = 'SAMPLING<ON>';
            
    }
    
    if(displayString == 'YES'){
        sampleDisplay -> setDisplay(true);
        output = 'SAMPLING<OFF>';
                       
    
    }
    sampleDisplay -> unlock();
    
}
 
void readInput() {
    
   char input[100];
   int place = 0;
   char c;
    while ( (c = getchar()) != 0xD ) {
       input[place] = c;
       place++;
    }
    input[place]=0; //End of string
       

        
    printCurrentString(input, 8);
        
}
 
 
// setting up gobal treads to be uses in the program
//Thread producter();
//Thread customer;
//Thread tempTread;
//Thread humTread;
//Thread pressTread(;
//Thread displayTread;
Thread deleteRecordTread(deleteRecord);
//Thread setDateTread;
//Thread setTimeTread;
//Thread dsiplaySelectedRecord;
//Thread updateTakeDisplay;
//Thread updateTreadTiming;
//Thread stringMutipluation; 
 
 
PwmOut mypwm(PWM_OUT);
 
DigitalOut myled(LED1);


int main() {
    
    
    

    //Thread* sampleThread = new Thread(doSomething);
    Thread sampleTread(updateSample);
    
     
    
    while(1) {
        
    
        
        readInput();
        
        
        myled = !myled;
        wait(1);
    }
}
 
