#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "Speaker.h"
#include "PinDetect.h"

int * frequency = NULL;
enum Color { red, green, blue };
Color myCol = red;

uLCD_4DGL uLCD(p28,p27,p30); // serial tx, serial rx, reset pin
PwmOut RGBLED_r(p23);
PwmOut RGBLED_g(p24);
PwmOut RGBLED_b(p25);
Speaker mySpeaker(p21); //setup speaker thread;
PinDetect up(p20);
PinDetect left(p19);
PinDetect down(p17);
PinDetect right(p16);
PinDetect center(p15);

Serial pc(USBTX, USBRX);
void center_button(void);

// Thread 1
// print counter into first line and wait for 1 s
//void uLCD_thread(void const *args)
//{
//    while(true) {       // thread loop
//        uLCD.locate(0,0);
//        uLCD.printf("Frequency: %d",*frequency);
//        uLCD.locate(3,0);
//        //uLCD.printf("Color: %d", (int)Color));
//        Thread::wait(1000);
//    }
//}
 
// Thread 2
// print counter into third line and wait for 0.5s
void sound_thread(void const *args)
{
    while(true) {       // thread loop
        Thread::signal_wait(0x2);
        mySpeaker.PlayNote(*frequency, .1, .8);
    }
}

// Thread 3
// RGB LED
//void RGB_thread(void const *args)
//{
//    while(true) {         // thread loop
//        Thread::signal_wait(0x3);    // wait 0.5s
//        switch (myCol) {
//            case red :
//                RGBLED_r = .5;
//                RGBLED_g = 0;
//                RGBLED_b = 0;
//                break;
//            case green :
//                RGBLED_r = 0;
//                RGBLED_g = 0.5;
//                RGBLED_b = 0;
//                break;
//            case blue :
//                RGBLED_r = 0;
//                RGBLED_g = 0;
//                RGBLED_b = 0.5;
//                break;
//        }
//    }
//}



//



//Thread t1(uLCD_thread);

//Thread t3(RGB_thread);

int main() {
    Thread t2(sound_thread);
    pc.printf("Initializing...\n");
    
    
    *frequency = 440;
    
    
    
    
//    center.attach_asserted(&center_button);
//    center.setSampleFrequency();
//    up.attach_asserted(&up_button);
//    up.setSampleFrequency();
//    left.attach_asserted(&left_button);
//    left.setSampleFrequency();
//    down.attach_asserted(&down_button);
//    down.setSampleFrequency();
//    right.attach_asserted(&right_button);
//    right.setSampleFrequency();
    
    
    
    while(true) {         // thread loop
        pc.printf("is this even working?\n");
        Thread::wait(1000);
        t2.signal_set(0x2);
        
    }
}

//void center_button(void) {
//    t2.signal_set(0x2);
//}
//void up_button(void) {
//    *frequency += 50;
//}
//void down_button(void) {
//    *frequency -= 50;
//}
//void left_button(void) {
//    switch (myCol) {
//        case red :
//            myCol = blue;
//            break;
//        case green :
//            myCol = red;
//            break;
//        case blue :
//            myCol = green;
//            break;
//    }
//    t3.signal_set(0x3);
//}
//void right_button(void) {
//    switch (myCol) {
//        case red :
//            myCol = green;
//            break;
//        case green :
//            myCol = blue;
//            break;
//        case blue :
//            myCol = red;
//            break;
//    }
//    t3.signal_set(0x3);
//}



