/*
 #include "mbed.h"
#include "DebounceIn.h"
#include "PinDetect.h"
#include <algorithm>
#include "math.h"
using namespace std;


PinDetect pb(p20);
PinDetect assemblyPB(p28);
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
DigitalOut assemblyLED(p30);
PwmOut discrete_led(p21);
AnalogIn voltage_reg(p17);

DigitalOut latch(p15);
SPI spi(p11, p12, p13);

int RGB_val[3] = {0,0,0};
// declare external assembly language function (in a *.s file)
extern "C" int my_asm(int value);

void RGB_intensity(float voltage) {
	float min_ = 0;
	float max_ = 1000;
	float ratio = 2 * (voltage-min_)/(max_-min_);
	float b = max(float(0), 1000*(1-ratio));
	float r = max(float(0), 1000*(ratio-1));
	float g = float(1000) - b - r;
	if (r<0) {r=0;}
	if (g<0) {g=0;}
	if (b<0) {b=0;}
	RGB_val[0] = int(r);
	RGB_val[1] = int(g);
	RGB_val[2] = int(b);
}

void RGB_LED(int red, int green, int blue) {
    unsigned int overallColor = 0;
    unsigned short int MSB = 0;
    unsigned short int LSB = 0;
    overallColor = (((blue<<10)|red)<<10)|(green);
    MSB = (overallColor>>16);
    LSB = overallColor;
    spi.write(MSB);
    spi.write(LSB);
    latch=1;
    latch=0;
}

class Watchdog {
public:
// Load timeout value in watchdog timer and enable
    void kick(float s) {
        LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
        uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4
        LPC_WDT->WDTC = s * (float)clk;
        LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset
        kick();
    }
// "kick" or "feed" the dog - reset the watchdog timer
// by writing this required bit pattern
    void kick() {
        LPC_WDT->WDFEED = 0xAA;
        LPC_WDT->WDFEED = 0x55;
    }
};


Watchdog wdt;


int main() {

	pb.mode(PullUp);
	assemblyPB.mode(PullUp);

	float brightness = 0;


	if (pb) {
		spi.format(16,0);
		spi.frequency(1000000);
		latch=0;
		wait(2);
		while(1) {

			//Assembly green LED
			my_asm(!assemblyPB);

			//code for red led
			brightness = voltage_reg;
			myled1 = !pb;
			if (!pb) {
				discrete_led.write(brightness);
			}
			else{
				discrete_led.write(0);
			}

			//code for multicolor led
			float heatmapColor = voltage_reg.read()*float(1000);
			if (heatmapColor < 0) {heatmapColor=0;}
			RGB_intensity(heatmapColor);
			RGB_LED(RGB_val[0], RGB_val[1], RGB_val[2]);
			//wait(.2);
		}

	}
	else {
		int count = 0;
		// On reset, indicate a watchdog reset or a pushbutton reset on LED 4 or 3
    	if ((LPC_WDT->WDMOD >> 2) & 1)
        	myled4 = 1; else myled3 = 1;

		// setup a 10 second timeout on watchdog timer hardware
		// needs to be longer than worst case main loop exection time
    	wdt.kick(10.0);

		// Main program loop - resets watchdog once each loop iteration
		// Would typically have a lot of code in loop with many calls
    	while (1) {
    		//Assembly Green LED
    		my_asm(!assemblyPB);

        	myled1 = 1; //Flash LEDs 1 & 2 to indicate normal loop activity
        	wait(.05);
        	myled1 = 0;
        	myled2 = 1;
        	wait(.05);
			// Simulate a fault lock up with an infinite while loop, but only after 25 loop iterations
        	if (count == 25) while (1) {};
			// LED 2 will stay on during the fault
        	myled2 = 0;
        	count ++;
			// End of main loop so "kick" to reset watchdog timer and avoid a reset
        	wdt.kick();
    	}
	}
}
// */
