/*// <- remove this if you want to code this and comment Georges
#include "mbed.h"
#include "DebounceIn.h"
#include "PinDetect.h"
#include <mpr121.h>

//// Simple LED Lighting using pushbutton
// PinDetect light(p8);
// PwmOut led(p21);
//
// int main() {
//   light.mode(PullUp);
//   while(1) {
//     led.write(!light);
//     }
// }

// 5-way switch test
BusOut mbedleds(LED1,LED2,LED3,LED4);
//BusOut/In is faster than multiple DigitalOut/Ins

class Nav_Switch
{
public:
    Nav_Switch(PinName up,PinName down,PinName left,PinName right,PinName fire);
    int read();
//boolean functions to test each switch
    bool up();
    bool down();
    bool left();
    bool right();
    bool fire();
//automatic read on RHS
    operator int ();
//index to any switch array style
    bool operator[](int index) {
        return _pins[index];
    };
private:
    BusIn _pins;

};
Nav_Switch::Nav_Switch (PinName up,PinName down,PinName left,PinName right,PinName fire):
    _pins(up, down, left, right, fire)
{
    _pins.mode(PullUp); //needed if pullups not on board or a bare nav switch is used - delete otherwise
    wait(0.001); //delays just a bit for pullups to pull inputs high
}
inline bool Nav_Switch::up()
{
    return !(_pins[0]);
}
inline bool Nav_Switch::down()
{
    return !(_pins[1]);
}
inline bool Nav_Switch::left()
{
    return !(_pins[2]);
}
inline bool Nav_Switch::right()
{
    return !(_pins[3]);
}
inline bool Nav_Switch::fire()
{
    return !(_pins[4]);
}
inline int Nav_Switch::read()
{
    return _pins.read();
}
inline Nav_Switch::operator int ()
{
    return _pins.read();
}

Nav_Switch myNav( p19, p16, p17, p15, p18); //pin order on Sparkfun breakout

int main()
{
    while(1) {
        //with pullups a button hit is a "0" - "~" inverts data to leds
        mbedleds = ~(myNav & 0x0F); //update leds with nav switch direction inputs
        if(myNav.fire()) mbedleds = 0x0F; //special all leds on case for fire (center button)
        //or use - if(myNav[4]==0) mbedleds = 0x0F; //can index a switch bit like this
        wait(0.02);
    }
}


//// Touch Keypad Demo
//
//DigitalOut led1(LED1);
//DigitalOut led2(LED2);
//DigitalOut led3(LED3);
//DigitalOut led4(LED4);
//// Create the interrupt receiver object on pin 26
//InterruptIn interrupt(p26);
//// Setup the i2c bus on pins 9 and 10
//I2C i2c(p9, p10);
//// Setup the Mpr121:
//// constructor(i2c object, i2c address of the mpr121)
//Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);
//
//// Key hit/release interrupt routine
//void fallInterrupt() {
//  int key_code=0;
//  int i=0;
//  int value=mpr121.read(0x00);
//  value +=mpr121.read(0x01)<<8;
//  // LED demo mod
//  i=0;
//  // puts key number out to LEDs for demo
//  for (i=0; i<12; i++) {
//  if (((value>>i)&0x01)==1) key_code=i+1;
//  }
//  led4=key_code & 0x01;
//  led3=(key_code>>1) & 0x01;
//  led2=(key_code>>2) & 0x01;
//  led1=(key_code>>3) & 0x01;
//}
//
//int main() {
//  interrupt.fall(&fallInterrupt);
//  interrupt.mode(PullUp);
//  while (1) {}
//}

// */
