#include "mbed.h"
#include "C12832.h"

C12832 lcd(p5, p7, p6, p8, p11);

Serial pc(USBTX, USBRX);

float x, y;

PwmOut Servo_X(p21);
PwmOut Servo_Y(p22);
PwmOut Servo_Z(p23);

int main() {
    while(1) {
        // Top left = 0.08 x 0.055 y 
        // Bottom right = 0.065 x 0.07y
        
        //0-1x -> 0.08-0.065x
        //0-1y -> 0.055-0.07y
        if (pc.readable())
            pc.scanf("%f,%f", &x, &y);
        
        float setX = 0.08f - (x * 0.015);
        float setY = 0.055f + (y * 0.015);
        
        //Servo_X = setX;// 0.05 min 0.09 max   
        //Servo_Y = setY; // Top left
        Servo_X = 0.08;
        Servo_Y = 0.055;
        Servo_Z = 0.07;
        
        
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("X: %f, Y: %f Z: %f", x, y, Servo_Z);
        
        wait(1);
    }
}