// Simple I2C responder
#include <mbed.h>

I2CSlave slave(I2C_SDA, I2C_SCL);
int main()
{
    char buf[10];
    char msg[] = "Slave!";

    slave.address(0x52);
    slave.frequency(400);
    while (1) {
        int i = slave.receive();
        switch (i) {
            case I2CSlave::ReadAddressed:
                slave.write(msg, strlen(msg) + 1); // Includes null char
                break;
            case I2CSlave::WriteGeneral:
                slave.read(buf, 10);
                printf("Read G: %s\n\r", buf);
                break;
            case I2CSlave::WriteAddressed:
                slave.read(buf, 10);
                printf("Read A: %s\n\r", buf);
                break;
            default:
                printf("No data received from master = %d\n\r",i);
                break;
        }
        for(int i = 0; i < 10; i++) buf[i] = 0;    // Clear buffer
    }
}