#include "mbed.h"
#include "rtos.h"
#include "HCSR04.h"


HCSR04 usensor(D15,D14);// (trig,echo)

Serial pc(USBTX, USBRX); //comunicacion serial

PwmOut servo(A2);
DigitalOut led1(LED1);
DigitalOut led2(LED2);

Thread thread_servo;
Thread thread_sensor;



unsigned int distancia;//tomara el valor de la distancia

void task_servo(){
    while(true){
        servo.pulsewidth_us(500);
        Thread::wait(1000);
        servo.pulsewidth_us(2000);
        Thread::wait(1000);
        }
    }

void task_sensor(){
    while(true){
        distancia = usensor.distance(CM);
        
        if(distancia<10){
            led1=0;
            led2=1;
            }
            else if(distancia<20){
                led1=1;
                led2=0;
                
                     }
             else{
                led1=1;
                led2=1;
                } 
        pc.printf("%u\n",distancia);
        Thread::wait(100);
        
        }
    }

int main() {
    
    pc.baud(9600);
    
    thread_servo.start(task_servo);
    thread_sensor.start(task_sensor);
    
    servo.period_ms(20);
    
    Thread thread_servo(osPriorityNormal);
    Thread thread_sensor(osPriorityNormal);
    
    
}

