#include "mbed.h"
#include "Servo.h"

Servo myservo(p26);
Serial pc(USBTX, USBRX);
 
int main() {
    
    pc.baud(4800);
    
    printf("Servo Calibration Controls:\n");
    printf("1,2,3 - Position Servo (full left, middle, full right)\n");
    printf("4,5 - Decrease or Increase range\n");
 
    float range = 0.0005;
    float position = 0.5;
    
    while(1) {                   
        switch(pc.getc()) {
            case '1': position = 0.005; break;
            case '2': position = 0.502; break;
            case '3': position = 1.050; break;
            case '4': range += 0.0001; break; 
            case '5': range -= 0.0001; break; 
            case '6': position = 0.005; 
                    while (position < 1.0)
                    { 
                        position += 0.001;
                        wait_ms(25);
                        myservo = position;
                        
                        float wert = myservo.read();
                        printf("read: %.3f", wert);
                        
                        if (position >= 0.998)
                            position = 0.0;
                    } 
                    
                        break;
            
        }
        printf("position = %.1f, range = +/-%0.4f\n", position, range);
        myservo.calibrate(range, 90.0); 
        myservo = position;
        float wert = myservo.read();
        printf("read: %.3f", wert);
        
    }
}