#include "mbed.h"
#include "platform/mbed_thread.h"
#include "HCSR04.h"
#include "rtos.h"

HCSR04 ultra (D8,D9); //Trig-Echo
Serial pc(USBTX,USBRX);
int distancia;
PwmOut servo(D6);
DigitalOut led(LED1);

Thread thread_servo;
Queue<uint32_t, 5> queue;
Timer timer;
float duracion;

void task_servo(){
    while(true){
        distancia = ultra.distance(CM);
        if (distancia>=20){
            distancia=20;
            }
        if(distancia<3){
            distancia=1; 
            }
        if(distancia<5){
            servo.pulsewidth_us(2500);
            }
            else if(distancia>5 && distancia<8){
            servo.pulsewidth_us(2100);
            }
            else if(distancia>8 && distancia<11){
            servo.pulsewidth_us(1700);
            }
            else if(distancia>11 && distancia<14){
            servo.pulsewidth_us(1300);
            }
            else if(distancia>14 && distancia<17){
            servo.pulsewidth_us(900);
            }
            else if(distancia>17){
            servo.pulsewidth_us(500);
            }
        Thread::wait(50);    
        }
}
void queue_isr(){
    queue.put((uint32_t*)distancia);
}

int main (){
    servo.period_ms(20);
    thread_servo.start(task_servo);
    Thread thread_servo(osPriorityNormal);
    Ticker ticker;
    ticker.attach(queue_isr,0.3);
    while (true){
        osEvent evt=queue.get();
        if(evt.status != osEventMessage){
            }
            else {
             printf("%d\n",evt.value.v);
            }
    }
}