#include "mbed.h"
#include "platform/mbed_thread.h"
#include "MFRC522.h"
#include "rtos.h"

#define SPI_MOSI    PB_15
#define SPI_MISO    PB_14
#define SPI_SCK     PB_13
#define MF_RESET    D8
#define SPI_CS      D14

int aux=0;
int aux2=0;
int signal=0;
MFRC522    RfChip (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET);
int main(){
    SPISlave device(D11,D12,D13,PA_15); // mosi, miso, sclk, cs
    printf("Mbed ready \r\n");
    device.format(8,0);             // bits=8, mode=0
    device.reply(0x21);             // Prime SPI with first reply
    // Init. RC522 Chip
    RfChip.PCD_Init();
    while(1) {
            
            if ( ! RfChip.PICC_IsNewCardPresent()){
              ThisThread::sleep_for(1000);
              printf("Reconocido \n\r");
              continue;
            }
            if ( ! RfChip.PICC_ReadCardSerial()){
              ThisThread::sleep_for(1000);
              continue;
            }
            printf("Card UID: \n\r");
            for (uint8_t i = 0; i < RfChip.uid.size; i++){
            printf(" %X02\n\r", RfChip.uid.uidByte[i]);
            }
            printf("\n\r");
            uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
            printf("PICC Type: %s \n\r", RfChip.PICC_GetTypeName(piccType));
            ThisThread::sleep_for(1000);
            } 
    }