#include "mbed.h"
#include <string>
#include "ESP8266.h"

ESP8266 esp(D8, D2, 9600);
Serial pc(D1, D0, 115200);

char snd[255], rcv[1000];

int main() {   
    pc.printf("Hello!! \n");
        
    pc.printf("Reset ESP\r\n");
    esp.Reset();
    esp.RcvReply(rcv, 400);
    pc.printf("%s", rcv);
    wait(2);
    
    pc.printf("Sending AT\r\n");
    strcpy(snd, "AT");
    esp.SendCMD(snd);
    esp.RcvReply(rcv, 400);
    pc.printf("%s", rcv);
    wait(2);
    
    pc.printf("Set mode to AP\r\n");
    esp.SetMode(1);
    esp.RcvReply(rcv, 1000);
    pc.printf("%s", rcv);
    
    pc.printf("Receiving Wifi List\r\n");
    esp.GetList(rcv);
    pc.printf("%s", rcv);
    
    pc.printf("Connecting to AP\r\n");
    esp.Join("Mind", "00000000"); // Replace MyAP and MyPasswd with your SSID and password
    esp.RcvReply(rcv, 1000);
    pc.printf("%s", rcv);
    wait(8);
    
    pc.printf("Check Connected\r\n");
    esp.look();
    esp.RcvReply(rcv, 400);
    pc.printf("%s", rcv);
    wait(2);
    
    pc.printf("Getting IP\r\n");
    esp.GetIP(rcv);
    pc.printf("%s", rcv);
    
    pc.printf("Setting single connections\r\n");
    esp.SetSingle();
    esp.RcvReply(rcv, 1000);
    pc.printf("%s", rcv);
    wait(4);
    
    pc.printf("Connect to Server\r\n");
    esp.SetPath("TCP", "172.20.10.3", "9999");
    esp.RcvReply(rcv, 1000);
    pc.printf("%s", rcv);
    wait(4);
    
    pc.printf("Check Connected To Server\r\n");
    esp.check();
    esp.RcvReply(rcv, 400);
    pc.printf("%s", rcv);
}