
#include "mbed.h"
#include "eeprom.h"
Serial pc(USBTX,USBRX);
EEPROM memory(PB_9,PB_8,1);// A2=0 A1=0 A0=1
BusIn dat(PB_4,PB_5,PB_3,PA_0,PA_1,PA_4,PB_0);
BusOut led(PA_5,PA_6,PA_7,PB_6,PC_7,PA_9,PA_8);
DigitalIn m(PC_1); //toggle switch to select mode
InterruptIn button(D2); //deboounce button
int mode = 0;
int tic=0;
void readmode(){
    if (m == 0){    // if m = Low
        mode=0;
        tic=1;
        
        }else{      // if m = High
            mode=1;
            tic=1;}
    }
int main()
{  
    int8_t ac;
    int16_t rcount=3;   
    int16_t count=3;
    button.fall(&readmode);
    for (int i =0;i<1000;i++){
        memory.write(i,0);
        }
    while(1){
        int8_t dac= dat.read();
        if (mode==0 & tic==1){           
            memory.write(count,dac);
            wait_ms(1);
            
            
            pc.printf("Data in address %d = %d\n",count,dac);
            count+=1;
            tic=0;
            rcount=3;
            }else if(mode ==1 & tic==1){
                memory.read(rcount,ac);
                led=ac;
            wait_ms(1);
            
             pc.printf("Read in address %d = %d\n",rcount,ac);
             rcount+=1;
            tic=0;
            count=3;
                }
        
        }

}