#include "mbed.h"
AnalogIn a1(A1);
DigitalOut led[]= {PA_5,PA_6,PA_7,PB_6,PC_7,PA_9,PA_8,PB_10};
DigitalOut dot(PB_2);
BusOut seg1(PC_0,PC_1,PB_0,PA_4);
BusOut seg2(PB_8,PB_9,PB_5,PB_3);
InterruptIn ff(D5); //Use for debounce button
int check=0;
int a;
void p1(float in,float us)      //Led Mode
{
    for (int i = 0 ; i<=8; i++) {
        if (us>=(3300/8)*(i)) {
            for (int j = 0; j<=i; j++) {
                led[j]=1;
            }
            for (int k = i; k<=8; k++) {
                led[k]=0;
            }
        }
    }
}
int b1(float p) // second Segment 
{
    int r= int(int(p)/100);
    return int(r%10);
}
void p2(float in,float us) //Sevensegment Mode
{
    wait(0.1);
    in=a1.read();
    us=in*3300;
    a=int(us/1000);
    seg1=a;
    dot=1;
    seg2=b1(us);
}
void toggle_on() //toggle mode 
{
    check = !check;
}
int main()
{
    float in;
    float us;
    ff.rise(&toggle_on);
    while(1) {
        in=a1.read();
        us=in*3300;
        if (check==1) {
            p2(in,us);
            for(int z =0; z<8; z++) {
                led[z]=0;
            }
        } else {
            p1(in,us);
            seg1=0;
            dot=0;
            seg2=0;
        }
    }
}
