#include "mbed.h"
DigitalIn sw1(USER_BUTTON);
DigitalIn sw2(D15);
DigitalIn sw3(D14);
DigitalOut leds[] = {PA_0,PA_1,PA_4,PB_0,PC_1,PC_0,PA_8,PB_10};
void blink(DigitalOut a,float time)// Led Blink
{
    a=1;
    wait(time);
    a=0;
    wait(time);
}
void pattern1(void)
{
    for(int k=0; k<=7; k++) {   //Led Blink 2 times from d0 to d7
        blink(leds[k],0.1);
        blink(leds[k],0.1);
        wait(0.01);
    }
}
void pattern2(void)
{
    for(int i=0; i<=7; i++) {   //Led on from d0 to d7
        leds[i]=1;
        wait(0.1);
    }
    for(int j=0; j<=7; j++) {  //Led off from d0 to d7
        leds[j]=0;
        wait(0.1);
    }
}
void pattern3(void)
{
    for(int k=0; k<=3; k++) {   //Led light on from d0 to d3 and from d7 to d4
        leds[k]=1;
        leds[7-k]=1;
        wait(0.1);
    }
    for(int x=0; x<=3; x++) {   //Led light off from d0 to d3 and from d7 to d4
        leds[x]=0;
        leds[7-x]=0;
        wait(0.1);
    }
}
int main()
{
    while(1) {
        if (sw2==1) {
            pattern2();         //Call Pattern2
        } else if (sw1==0) {
            pattern1();         //Call Pattern1
        } else if(sw3==1) {
            pattern3();         //Call Pattern3
        }
    }
}


