#include "mbed.h"
#include "eeprom.h"

EEPROM memory(I2C_SDA,I2C_SCL,0);
DigitalIn mod(D2);
InterruptIn send(D11);
BusIn data(D3,D4,D5,D6,D7,D8,D9);
BusOut Led(A5,A4,A3,A2,A1,A0,D10);
Serial pc(D1,D0);
int8_t out,write;

void eewrite()
{
        write = data;
        memory.write(0xFF,write);
        pc.printf("%x\n",write);
                
        wait_ms(10);
}

void eeread()
{
            memory.read(0xFF,out);
            pc.printf("%x\n",out);
            Led = out;
                
            wait_ms(10);
}
    

int main()
{
    while(1)
    {
        if(mod==1)
        {
            send.rise(eewrite);
            wait_ms(10);
        }
        else if(mod==0)
        {
            send.rise(eeread);
            wait_ms(10);
        }
    }
    
}
    
