#include "mbed.h"

Serial pc(D8,D3);
BusOut Seg1(D4,D5,D6,D7);
BusOut Seg2(D9,D10,D11,D12);
AnalogIn Voltage(A0);

int main()
{

    uint8_t state_menu=0;
    uint8_t state_show=0;
    uint8_t state_exit =0;
    uint8_t data;
    int num[5];
    int i=0;

    pc.printf("Wellcome !\n");
    while(1) {
        if(state_show == 0) {
            pc.printf("Menu\n");
            pc.printf("1.Sending Numbers \n");
            pc.printf("2.Voltage Indicator\n");
            state_show =1;
        }
        if(pc.readable()) {
            data = pc.getc();
            pc.printf("\n");
            state_show =0;
            state_exit =0;

            switch(data) {
                case '1':
                    do {
                        if(state_menu == 0) {
                            pc.printf("Sending Numbers\n");
                            pc.printf("Please send the number 00-99 \n Or press x to exit\n\n");
                            state_menu = 1;
                            }
                        do {
                            num[i] = pc.getc();
                            if(num[i]=='x'){
                                state_exit = 1;
                                } 
                            wait_ms(50);
                            i++;
                        } while(pc.readable());
                        if(i>=2) { 
                            Seg1 = num[i-2]-48;
                            Seg2 = num[i-1]-48;
                            state_menu = 0;
                            i=0;
                            }

                    } while(state_exit ==0);
                    Seg1 = 0;
                    Seg2 = 0;
                    pc.printf("\n\n");
                    break;

                case '2':

                    do {
                        if(state_menu == 0) {
                            pc.printf("Logic Input Test\n\n");
                            
                            float Volt;
                            Volt = Voltage.read();
                            pc.printf("Voltage is %f volts\n",Volt*3.3);                           
                            
                            pc.printf("press x to exit or else to remesure\n\n");         
                            state_menu = 1;
                            }
                        if(pc.readable()) {
                            data = pc.getc();
                            if (data == 'x') state_exit = 1;
                            else state_menu = 0;
                        }



                    } while(state_exit ==0);
                    pc.printf("\n\n");
                    break;


                case 0x00:

                    break;

                default:
                    pc.printf("plz select 1 or 2 only\n");
                    pc.printf("\n\n");
                    break;
            }
        }






    }
}
