#include "select-demo.h"

#if DEMO == DEMO_HTTP

#include "rtos.h"
#include "mbed.h"
#include "http_request.h"
#include "network-helper.h"
#include "mbed_mem_trace.h"
#include "PinDetect.h"




//FINITE STATE MACHINE EVENTS
#define NO_EVENT 0
#define TIME_OUT 1
#define BUTTON_PRESS_1 2
#define BUTTON_PRESS_2 3
#define TILT 3
#define PUSH 4

//STATES
#define STATE_0 0
#define STATE_1 1
#define STATE_2 2


//pass event via message queue
typedef struct {
    int    event;   /* AD result of measured voltage */
} message_t;

MemoryPool<message_t, 16> mpool;
Queue<message_t, 16> queue;

//Digital input
//DigitalIn coin(p14);
PinDetect button_1(p23);
PinDetect button_2(p24);

//Global varible
int button_press_1=0;
int button_press_2=0;
int button_press_Wait=0;


//leds for debug
DigitalOut led4(LED4); //LED
DigitalOut led3(LED3); //LED
DigitalOut led2(LED2); //LED
DigitalOut myled(LED1);

//Relays:

DigitalOut Relay_1(p11);
DigitalOut Relay_2(p12);



//Mutex
Mutex flag_mutex;


void button_1_event_thread(void const *argument)
{

   
    while (true)
     {
        //Thread::wait(10);
        if (button_press_1 == 1 && button_press_2 == 0 && button_press_Wait==0) {

            //event via a message queue
            button_press_Wait=1;
            message_t *message = mpool.alloc();
            message->event = BUTTON_PRESS_1;
            queue.put(message);

            led3 = !led3;
            Thread::wait(5000);
        }

    }
}


void button_2_event_thread(void const *argument)
{

    
    while (true)
     {
        //Thread::wait(10);
        if (button_press_2 == 1 && button_press_1 == 0 && button_press_Wait==0) {

            //event via a message queue
            button_press_Wait = 1;
            message_t *message = mpool.alloc();
            message->event = BUTTON_PRESS_2;
            queue.put(message);

            led2 = !led2;
            Thread::wait(5000);

        }

    }
}


void timeout_event(void const *n)
{

    //event via a message queue
    message_t *message = mpool.alloc();
    message->event = TIME_OUT;
    queue.put(message);

    led4 =  !led4;

}


void  button_1_hit_callback()
{
//Flash_LED_Thread.signal_set(0x1);

    button_press_1=1;   

}

void  button_2_hit_callback()
{
//Flash_LED_Thread.signal_set(0x1);

    button_press_2=1;

}





void dump_response_1(HttpResponse* res) 
{
   
    Relay_1=0;
    Relay_2=1;
    

    printf("Status: %d - %s\n", res->get_status_code(), res->get_status_message().c_str());

    printf("Headers:\n");
    for (size_t ix = 0; ix < res->get_headers_length(); ix++)
    {
        printf("\t%s: %s\n", res->get_headers_fields()[ix]->c_str(), res->get_headers_values()[ix]->c_str());
    }
    printf("\nBody (%d bytes):\n\n%s\n", res->get_body_length(), res->get_body_as_string().c_str());
    
    Thread::wait(5000);
    Relay_1=1;
   
    Thread::wait(5000);
    button_press_2 = 0;
    button_press_1 = 0;
   button_press_Wait = 0;
    
}


void dump_response_2(HttpResponse* res)
{
    Relay_1=1;
    Relay_2=0;
    
    printf("Status: %d - %s\n", res->get_status_code(), res->get_status_message().c_str());

    printf("Headers:\n");
    for (size_t ix = 0; ix < res->get_headers_length(); ix++) {
        printf("\t%s: %s\n", res->get_headers_fields()[ix]->c_str(), res->get_headers_values()[ix]->c_str());
    }
    printf("\nBody (%d bytes):\n\n%s\n", res->get_body_length(), res->get_body_as_string().c_str());
    
    
    Thread::wait(5000);
    Relay_2=1;
    
    Thread::wait(5000);
    button_press_2 = 0;
    button_press_1 = 0;
   
   button_press_Wait = 0;
 

}


int main() 
{
    
    
    Relay_1=1;
    
    Relay_2=1;
    //Thread fsm(fsm_thread);
    Thread button_1_event(button_1_event_thread);
    Thread button_2_event(button_2_event_thread);
    
    
    
    RtosTimer timer(timeout_event, osTimerPeriodic, (void *)0);
    
    
    button_1.mode(PullUp);
    button_2.mode(PullUp);
    
    //Interrupts
   /* button_1.fall(&Button_1_Inter);
    button_2.fall(&Button_2_Inter);*/
    
     // Setup Interrupt callback function for a pb hit
    button_1.attach_deasserted(& button_1_hit_callback);
    // Start sampling pb input using interrupts
    button_1.setSampleFrequency();
    
    // Setup Interrupt callback function for a pb hit
    button_2.attach_deasserted(& button_2_hit_callback);
    // Start sampling pb input using interrupts
    button_2.setSampleFrequency();
 

    
    
    int state = STATE_0;
    while (true) 
    {
        Thread::wait(4000);
        
        //network setup
        NetworkInterface* network = connect_to_default_network_interface();
        if (!network)
        {
            printf("Cannot connect to the network, see serial output\n");
                    //return 1;
            for(int j = 0 ; j<20;j++)
            {
                led4=1;
                Thread::wait(100);
                led4=0;
                Thread::wait(100);
            }
        }
        else
        {
            led4=1;
        
            while (true) {
        
        
                switch(state) {
                    case STATE_0:
                        osEvent evt = queue.get();
                        if (evt.status == osEventMessage) 
                        {
                            message_t *message = (message_t*)evt.value.p;
        
        
                            if(message->event == BUTTON_PRESS_1) 
                            {
                                printf("HttpRequest Sending");
                                //printf(network->get_gateway);
                                HttpRequest* post_req = new HttpRequest(network, HTTP_POST, "http://10.5.248.2:5600/mch/kick");
                                
                                post_req->set_header("Content-Type", "application/json");
                             
                                
                                const char body[] = "{\"hello\":\"Nada\"}";
                                    
                                HttpResponse* post_res = post_req->send(body, strlen(body));
                                if (!post_res)
                                {
                                    printf("HttpRequest failed (error code %d)\n", post_req->get_error());
                                   // return 1;
                                   
                                    button_press_2 = 0;
                                    button_press_1 = 0;
                                }
                                else
                                {
                                
                                    printf("\n----- HTTP POST response 1-----\n");
                                    
                                    dump_response_1(post_res);
                                    
                                    //Thread::wait(5000);
                                    
        
                                        
                                     delete post_req;
                                 }
                                 
                                 state = STATE_0;
                            }
                            else if(message->event == BUTTON_PRESS_2) 
                            {
                                
                                HttpRequest* post_req = new HttpRequest(network, HTTP_POST, "http://10.5.248.2:5600/mch/call");
                                
                                post_req->set_header("Content-Type", "application/json");
                             
                                
                                const char body[] = "{\"hello\":\"World\"}";
                                    
                                HttpResponse* post_res = post_req->send(body, strlen(body));
                                if (!post_res)
                                {
                                    printf("HttpRequest failed (error code %d)\n", post_req->get_error());
                                   // return 1;
                                   
                                    button_press_2 = 0;
                                    button_press_1 = 0;                           
                                }
                                else
                                {
                            
                                    printf("\n----- HTTP POST response 2-----\n");
                                    
                                    dump_response_2(post_res);
                                        
                                    delete post_req;
                                    //Thread::wait(5000);
                                    
        
        
                    
                                }
                                 state = STATE_0;
                            }
        
                            mpool.free(message);
                        }
        
                        timer.start(15000);
        
                        break;
        
                    case STATE_1:
        
                        evt = queue.get();
                        if (evt.status == osEventMessage) 
                        {
                            message_t *message = (message_t*)evt.value.p;
        
        
                            if(message->event == BUTTON_PRESS_1) 
                            {
                                
                                state = STATE_0;
                            }
                            
                            mpool.free(message);
                        }
        
                        timer.start(10000);
        
                        break;
        
        
                }//End of switch
        
                //toggle led for local testing
                //led2= !led2;
        
            }//end of while(1)
        }
    }            
}

#endif
